/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.file;

import at.mrdevelopment.toolkit.InitializationException;
import java.io.File;
import java.util.regex.Pattern;
import org.apache.commons.configuration.PropertiesConfiguration;

public abstract class CsvConfiguration {
    private final ImportSource importSource;
    private final ImportFileFormat importFileFormat;
    private final String importDirectory;
    private final Pattern importFilePattern;
    private final File conversionStylesheet;
    private final boolean deleteFileAfterImport;
    private final boolean moveFileAfterImport;
    private final String moveDirectory;
    private final boolean writeImportReport;
    private final String delimiter;
    private final String charset;
    private final boolean skipHeaderLine;
    private final Integer reloadSeconds;
    private final String ftpHost;
    private final int ftpPort;
    private final String ftpLogin;
    private final String ftpPassword;

    public CsvConfiguration(PropertiesConfiguration configuration) throws InitializationException {
        this.importSource = ImportSource.valueOf(configuration.getString("source", ImportSource.FILE.toString()).toUpperCase());
        this.importFileFormat = ImportFileFormat.valueOf(configuration.getString("format", ImportFileFormat.CSV.toString()).toUpperCase());
        this.importDirectory = configuration.getString("directory");
        this.importFilePattern = this.getPattern(configuration.getString("filePattern"));
        this.conversionStylesheet = new File(configuration.getString("conversionStylesheet", "config/import.xsl"));
        this.deleteFileAfterImport = configuration.getBoolean("deleteFileAfterImport", false);
        this.moveFileAfterImport = configuration.getBoolean("moveFileAfterImport", false);
        this.moveDirectory = configuration.getString("moveDirectory");
        this.writeImportReport = configuration.getBoolean("writeImportReport", false);
        this.delimiter = configuration.getString("delimiter", ";");
        this.charset = configuration.getString("charset", "UTF-8");
        this.skipHeaderLine = configuration.getBoolean("skipHeaderLine", false);
        this.reloadSeconds = configuration.getInteger("reloadSeconds", Integer.valueOf(10));
        if (this.importSource == ImportSource.FTP) {
            this.ftpHost = configuration.getString("ftpHost", null);
            this.ftpPort = configuration.getInt("ftpPort", 21);
            this.ftpLogin = configuration.getString("ftpLogin", null);
            this.ftpPassword = configuration.getString("ftpPassword", null);
        } else {
            this.ftpHost = null;
            this.ftpPort = -1;
            this.ftpLogin = null;
            this.ftpPassword = null;
        }
        this.validateConfiguration();
    }

    private void validateConfiguration() throws InitializationException {
        if (this.importFilePattern == null) {
            throw new InitializationException("Missing import file pattern", new Object[0]);
        }
        if (this.importSource == ImportSource.FTP && (this.ftpHost == null || this.ftpHost.isEmpty())) {
            throw new InitializationException("Missing host for FTP import", new Object[0]);
        }
        if (this.reloadSeconds <= 0) {
            throw new InitializationException("Illegal value for import reload time (must be positive)", new Object[0]);
        }
    }

    protected abstract void validate() throws InitializationException;

    private Pattern getPattern(String pattern) {
        return pattern != null && !pattern.isEmpty() ? Pattern.compile(pattern) : null;
    }

    public ImportSource getImportSource() {
        return this.importSource;
    }

    public ImportFileFormat getImportFileFormat() {
        return this.importFileFormat;
    }

    public String getImportDirectory() {
        return this.importDirectory;
    }

    public Pattern getImportFilePattern() {
        return this.importFilePattern;
    }

    public File getConversionStylesheet() {
        return this.conversionStylesheet;
    }

    public boolean isDeleteFileAfterImport() {
        return this.deleteFileAfterImport;
    }

    public boolean isMoveFileAfterImport() {
        return this.moveFileAfterImport;
    }

    public String getMoveDirectory() {
        return this.moveDirectory;
    }

    public boolean isWriteImportReport() {
        return this.writeImportReport;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public String getCharset() {
        return this.charset;
    }

    public boolean isSkipHeaderLine() {
        return this.skipHeaderLine;
    }

    public Integer getReloadSeconds() {
        return this.reloadSeconds;
    }

    public String getFtpHost() {
        return this.ftpHost;
    }

    public int getFtpPort() {
        return this.ftpPort;
    }

    public String getFtpLogin() {
        return this.ftpLogin;
    }

    public String getFtpPassword() {
        return this.ftpPassword;
    }

    protected abstract StringBuilder toString(StringBuilder var1);

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(String.format("importSource = %s%n", new Object[]{this.importSource}));
        builder.append(String.format("importFileFormat = %s%n", new Object[]{this.importFileFormat}));
        builder.append(String.format("importDirectory = %s%n", this.importDirectory));
        builder.append(String.format("importFilePattern = %s%n", this.importFilePattern.pattern()));
        builder.append(String.format("deleteFileAfterImport = %b%n", this.deleteFileAfterImport));
        builder.append(String.format("writeImportReport = %b%n", this.writeImportReport));
        builder.append(String.format("moveFileAfterImport = %b%n", this.moveFileAfterImport));
        builder.append(String.format("moveDirectory = %s%n", this.moveDirectory));
        builder.append(String.format("delimiter = %s%n", this.delimiter));
        builder.append(String.format("charset = %s%n", this.charset));
        builder.append(String.format("skipHeaderLine = %b%n", this.skipHeaderLine));
        builder.append(String.format("reloadSeconds = %d%n", this.reloadSeconds));
        builder.append(String.format("ftpHost = %s%n", this.ftpHost));
        builder.append(String.format("ftpPort = %d%n", this.ftpPort));
        builder.append(String.format("ftpLogin = %s%n", this.ftpLogin));
        builder.append(String.format("ftpPassword = (hidden)", new Object[0]));
        return this.toString(builder).toString();
    }

    public static enum ImportFileFormat {
        CSV,
        XML;

    }

    public static enum ImportSource {
        FTP,
        FILE;

    }
}

