/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.file;

import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.file.AbstractImportReport;
import at.mrdevelopment.toolkit.file.AbstractRecordReader;
import at.mrdevelopment.toolkit.file.CsvConfiguration;
import at.mrdevelopment.toolkit.file.ImportRecordException;
import at.mrdevelopment.toolkit.file.ImportRecordHandler;
import at.mrdevelopment.toolkit.xml.XMLToolkit;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public abstract class AbstractXmlRecordReader<R extends AbstractImportReport<?, ? extends Enum<?>>>
extends AbstractRecordReader<R> {
    private final XMLToolkit xmlToolkit = new XMLToolkit();
    private final StreamSource xsltSource;

    public AbstractXmlRecordReader(ImportRecordHandler<R> handler, CsvConfiguration configuration) throws InitializationException {
        super(handler, configuration);
        this.xsltSource = new StreamSource(configuration.getConversionStylesheet());
    }

    @Override
    public void readRecords(String fileName, InputStream inputStream, R report, Map<String, String> parameters) throws ImportRecordException {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            StreamSource xmlSource = new StreamSource(inputStream);
            StreamResult result = new StreamResult(outputStream);
            this.xmlToolkit.transform(this.xsltSource, xmlSource, result, parameters);
            List<String[]> records = this.getCsvReader().read(new ByteArrayInputStream(outputStream.toByteArray()), this.getConfiguration().getCharset());
            for (String[] record : records) {
                this.getHandler().importRecord(record, report);
            }
        }
        catch (Exception exc) {
            throw new ImportRecordException(exc);
        }
    }
}

