/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.encoding.dc2;

import at.mrdevelopment.toolkit.encoding.dc2.Binary;

public class BitInputStream {
    private static final int MAX_BIT_POSITION_IN_BYTE = 7;
    private static final int BIT_COUNT_IN_BYTE = 8;
    private final byte[] data;
    private int byteIndex;
    private int bitIndex;
    private final int bitCount;
    private int bitReadedCount;

    public BitInputStream(byte[] data) {
        this.data = (byte[])data.clone();
        this.bitCount = data.length * 8;
        this.byteIndex = 0;
        this.bitIndex = 7;
        this.bitReadedCount = 0;
    }

    public BitInputStream(Binary binary) {
        this.data = binary.getData();
        this.bitCount = binary.getBitCount();
        this.byteIndex = 0;
        this.bitIndex = 7;
        this.bitReadedCount = 0;
    }

    public int read() {
        int value;
        if (this.bitReadedCount == this.bitCount || this.byteIndex == this.data.length) {
            value = -1;
        } else {
            value = this.data[this.byteIndex] >> this.bitIndex & 1;
            if (--this.bitIndex < 0) {
                this.bitIndex = 7;
                ++this.byteIndex;
            }
            ++this.bitReadedCount;
        }
        return value;
    }

    public int read(int bitToReadCount) {
        int result = 0;
        for (int count = bitToReadCount - 1; count >= 0; --count) {
            if (this.bitReadedCount == this.bitCount || this.byteIndex == this.data.length) {
                throw new IllegalArgumentException("no more bit available");
            }
            int value = this.read();
            result |= value << count;
        }
        return result;
    }

    public void reset() {
        this.byteIndex = 0;
        this.bitIndex = 7;
        this.bitReadedCount = 0;
    }

    public int getBitCount() {
        return this.bitCount;
    }

    public int getBitReadedCount() {
        return this.bitReadedCount;
    }

    public int available() {
        return this.bitCount - this.bitReadedCount;
    }

    public boolean hasBit() {
        return this.bitReadedCount != this.bitCount && this.byteIndex != this.data.length;
    }
}

