/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.encoding.dc2;

import at.mrdevelopment.toolkit.encoding.dc2.MathUtil;
import java.io.Serializable;
import java.util.Arrays;

public class Binary
implements Serializable {
    private static final int MAX_BIT_POSITION_IN_BYTE = 7;
    private static final int BIT_COUNT_IN_BYTE = 8;
    private final int bitCount;
    private byte[] data;

    public Binary(int numberOfBits, byte[] data) {
        this.bitCount = numberOfBits;
        this.data = (byte[])data.clone();
    }

    public Binary(byte[] buffer) {
        this(buffer.length * 8, buffer);
    }

    public byte[] getData() {
        return (byte[])this.data.clone();
    }

    protected void setData(byte[] data) {
        this.data = (byte[])data.clone();
    }

    public int getBitCount() {
        return this.bitCount;
    }

    public void writeAt(int bitPosition, int value, int pBitCount) {
        if (MathUtil.bitCount(value) > pBitCount) {
            throw new IllegalArgumentException("value needed more than " + pBitCount + " to be writen");
        }
        for (int i = 0; i < pBitCount; ++i) {
            this.writeAt(bitPosition + i, (value & 1 << pBitCount - i - 1) >> pBitCount - i - 1);
        }
    }

    public void writeAt(int bitPosition, int value) {
        if (value < 0 && value > 1) {
            throw new IllegalArgumentException("value must be 0 or 1");
        }
        if (bitPosition >= this.bitCount) {
            throw new IllegalArgumentException("Out of range position : " + bitPosition + " bitCount : " + this.bitCount);
        }
        int byteIndex = bitPosition / 8;
        byte newValue = this.data[byteIndex];
        int bitIndex = 7 - bitPosition % 8;
        int valueBit = newValue >> bitIndex & 1;
        if (valueBit == 1 && value == 0) {
            newValue = (byte)(newValue ^ 1 << bitIndex);
        } else if (valueBit == 0 && value == 1) {
            newValue = (byte)(newValue | 1 << bitIndex);
        }
        this.data[byteIndex] = newValue;
    }

    public int readAt(int bitPosition) {
        int byteIndex = bitPosition / 8;
        int bitIndex = 7 - bitPosition % 8;
        byte newValue = this.data[byteIndex];
        return newValue >> bitIndex & 1;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.data);
        result = 31 * result + this.bitCount;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Binary other = (Binary)obj;
        if (!Arrays.equals(this.data, other.data)) {
            return false;
        }
        return this.bitCount == other.bitCount;
    }

    public String toString() {
        return new String(this.data);
    }
}

