/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.encoding;

import at.mrdevelopment.toolkit.encoding.DataEncoding;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;

public class SimpleThreeByteRunLengthEncoding
implements DataEncoding {
    private static final byte MAGIC_NUMBER = -86;

    @Override
    public byte[] encode(byte[] decoded) {
        ThreeByteRunLength rle = new ThreeByteRunLength();
        for (int index = 0; index < decoded.length; ++index) {
            byte value = decoded[index];
            if (decoded[index] == rle.value) {
                if (rle.runLength == 256) {
                    rle.write();
                }
            } else {
                rle.write();
                rle.value = value;
            }
            ++rle.runLength;
        }
        rle.write();
        return ArrayUtils.toPrimitive((Byte[])rle.data.toArray(new Byte[rle.data.size()]));
    }

    @Override
    public byte[] decode(byte[] encoded) {
        ArrayList<Byte> decoded = new ArrayList<Byte>();
        int position = 0;
        int index = 0;
        while (index < encoded.length) {
            byte value;
            if ((value = encoded[index++]) == -86) {
                value = encoded[index++];
                int runLength = (encoded[index++] & 0xFF) + 1;
                for (int offset = 0; offset < runLength; ++offset) {
                    decoded.add(position + offset, value);
                }
                position += runLength;
                continue;
            }
            decoded.add(position++, value);
        }
        return ArrayUtils.toPrimitive((Byte[])decoded.toArray(new Byte[decoded.size()]));
    }

    private static class ThreeByteRunLength {
        List<Byte> data = new ArrayList<Byte>();
        byte value = 0;
        int runLength = 0;

        private ThreeByteRunLength() {
        }

        public void write() {
            if (this.value != -86 && this.runLength == 1) {
                this.data.add(this.value);
            } else if (this.runLength > 0) {
                this.data.add((byte)-86);
                this.data.add(this.value);
                this.data.add((byte)(this.runLength - 1));
            }
            this.runLength = 0;
        }
    }
}

