/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.encoding;

import at.mrdevelopment.toolkit.encoding.DataEncoding;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;

public class SimpleByteRunLengthWithBWTEncoding
implements DataEncoding {
    @Override
    public byte[] encode(byte[] decoded) {
        BWT bwt = new BWT();
        if (decoded.length % 8 != 0) {
            throw new RuntimeException("Data must be multiple of 8");
        }
        for (int index = 0; index < decoded.length; ++index) {
            byte value = decoded[index];
            bwt.write(value);
        }
        return ArrayUtils.toPrimitive((Byte[])bwt.data.toArray(new Byte[bwt.data.size()]));
    }

    @Override
    public byte[] decode(byte[] encoded) {
        List<Byte> decoded = this.decodeInternal(encoded);
        return ArrayUtils.toPrimitive((Byte[])decoded.toArray(new Byte[decoded.size()]));
    }

    private List<Byte> decodeInternal(byte[] encoded) {
        ArrayList<Byte> decoded = new ArrayList<Byte>();
        byte value = 0;
        int bwtIndex = 0;
        int dataIndex = 1;
        while (bwtIndex < encoded.length) {
            byte bwtByte = encoded[bwtIndex];
            for (int byteIndex = 0; byteIndex < 8; ++byteIndex) {
                if ((bwtByte & 0xFFFFFF80) != -128) {
                    value = encoded[dataIndex++];
                }
                decoded.add(value);
                bwtByte = (byte)(bwtByte << 1);
            }
            bwtIndex = dataIndex;
            dataIndex = bwtIndex + 1;
        }
        return decoded;
    }

    private static class BWT {
        List<Byte> data = new ArrayList<Byte>();
        int bwtIndex = 0;
        int dataIndex = 0;
        int position = 0;
        byte value = 0;

        private BWT() {
        }

        public void write(byte value) {
            boolean run;
            boolean bl = run = this.position != 0 && this.value == value;
            if (this.position % 8 == 0) {
                this.bwtIndex = this.dataIndex;
                this.data.add(this.bwtIndex, (byte)0);
                this.dataIndex = this.bwtIndex + 1;
            }
            if (run) {
                byte bwtByte = this.data.get(this.bwtIndex);
                bwtByte = (byte)(bwtByte | (byte)(1 << 7 - this.position % 8));
                this.data.set(this.bwtIndex, bwtByte);
            }
            if (!run) {
                this.data.add(this.dataIndex++, value);
                this.value = value;
            }
            ++this.position;
        }
    }
}

