/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.encoding;

import at.mrdevelopment.toolkit.encoding.DataEncoding;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;

public class SimpleBitRunLengthEncoding
implements DataEncoding {
    @Override
    public byte[] encode(byte[] encoded) {
        BitRunLength rle = new BitRunLength();
        for (int index = 0; index < encoded.length; ++index) {
            for (int bit = 0; bit < 8; ++bit) {
                boolean value;
                boolean bl = value = (encoded[index] & 1 << bit) != 0;
                if (value == rle.value) {
                    if (rle.runLength == 128) {
                        rle.write();
                    }
                } else {
                    rle.write();
                    rle.value = value;
                }
                ++rle.runLength;
            }
        }
        rle.write();
        return rle.toArray();
    }

    @Override
    public byte[] decode(byte[] encoded) {
        ArrayList<Byte> decoded = new ArrayList<Byte>();
        int position = 0;
        byte data = 0;
        for (byte rleByte : encoded) {
            boolean value = (rleByte & 0x80) != 0;
            int runLength = (rleByte & 0x7F) + 1;
            for (int offset = 0; offset < runLength; ++offset) {
                int index = position + offset;
                int bitValue = value ? 1 : 0;
                data = (byte)(data | bitValue << index % 8);
                if (index % 8 != 7) continue;
                decoded.add(index / 8, data);
                data = 0;
            }
            position += runLength;
        }
        return ArrayUtils.toPrimitive((Byte[])decoded.toArray(new Byte[decoded.size()]));
    }

    private static class BitRunLength {
        List<Byte> data = new ArrayList<Byte>();
        boolean value = false;
        int runLength = 0;

        private BitRunLength() {
        }

        public void write() {
            if (this.runLength > 0) {
                byte encoded = this.encode(this.value, this.runLength);
                this.data.add(encoded);
                this.runLength = 0;
            }
        }

        private byte encode(boolean value, int runLength) {
            return (byte)((value ? -128 : 0) | (byte)(runLength - 1));
        }

        public byte[] toArray() {
            byte[] result = new byte[this.data.size()];
            for (int index = 0; index < this.data.size(); ++index) {
                result[index] = this.data.get(index);
            }
            return result;
        }
    }
}

