/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.definition;

import at.mrdevelopment.toolkit.barcode.Barcode1D;
import at.mrdevelopment.toolkit.barcode.specific.Code39Code;
import at.mrdevelopment.toolkit.barcode.specific.DataMatrixCode;
import at.mrdevelopment.toolkit.barcode.specific.EAN13Code;
import at.mrdevelopment.toolkit.barcode.specific.EAN8Code;
import at.mrdevelopment.toolkit.barcode.specific.ITF14Code;
import at.mrdevelopment.toolkit.barcode.specific.Intl2of5Code;
import at.mrdevelopment.toolkit.barcode.specific.QRCode;
import at.mrdevelopment.toolkit.barcode.specific.UPCACode;
import at.mrdevelopment.toolkit.barcode.specific.UPCECode;
import at.mrdevelopment.toolkit.definition.AttributeDescription;
import at.mrdevelopment.toolkit.definition.Example;
import at.mrdevelopment.toolkit.image.BorderStyle;
import at.mrdevelopment.toolkit.image.RoundedCorner;
import at.mrdevelopment.toolkit.image.VerticalAlignment;
import at.mrdevelopment.toolkit.options.BooleanOption;
import at.mrdevelopment.toolkit.options.ColorOption;
import at.mrdevelopment.toolkit.options.DescendingDoubleArrayOption;
import at.mrdevelopment.toolkit.options.DescendingIntegerArrayOption;
import at.mrdevelopment.toolkit.options.DoubleOption;
import at.mrdevelopment.toolkit.options.EnumOption;
import at.mrdevelopment.toolkit.options.IntegerOption;
import at.mrdevelopment.toolkit.options.Option;
import at.mrdevelopment.toolkit.options.OptionException;
import at.mrdevelopment.toolkit.options.Size;
import at.mrdevelopment.toolkit.options.SizeOption;
import at.mrdevelopment.toolkit.options.StringOption;
import at.mrdevelopment.toolkit.options.UnorderedEnumArrayOption;
import at.mrdevelopment.toolkit.options.UnorderedPointArrayOption;
import at.mrdevelopment.toolkit.text.Alignment;
import at.mrdevelopment.toolkit.text.LineWrap;
import at.mrdevelopment.toolkit.text.SuperScript;
import at.mrdevelopment.toolkit.text.TextElement;
import java.awt.Color;
import java.awt.Point;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public enum Attribute {
    ID("id", null, String.class, StringOption.class, false, AttributeDescription.ID, new Example[]{Example.CSS_1}),
    CLASS("class", null, String.class, StringOption.class, false, AttributeDescription.CLASS, new Example[]{Example.CSS_1}),
    COLOR("color", Color.black, Color.class, ColorOption.class, true, AttributeDescription.COLOR),
    COLORS("colors", false, Boolean.class, BooleanOption.class, false, AttributeDescription.COLOR, new Example[]{Example.EXAMPLE_NESTED_FIELDS}),
    BACKGROUND_COLOR("background-color", new Color(255, 255, 255, 0), Color.class, ColorOption.class, true, AttributeDescription.BACKGROUND_COLOR),
    WIDTH("width", null, Integer.class, IntegerOption.class, false, AttributeDescription.WIDTH),
    HEIGHT("height", null, Integer.class, IntegerOption.class, false, AttributeDescription.HEIGHT),
    DITHERING("dithering", false, Boolean.class, BooleanOption.class, false, AttributeDescription.DITHERING),
    CLIP_X("clip-x", null, Integer.class, IntegerOption.class, false, AttributeDescription.CLIP_X),
    CLIP_Y("clip-y", null, Integer.class, IntegerOption.class, false, AttributeDescription.CLIP_Y),
    CLIP_WIDTH("clip-width", null, Integer.class, IntegerOption.class, false, AttributeDescription.CLIP_WIDTH),
    CLIP_HEIGHT("clip-height", null, Integer.class, IntegerOption.class, false, AttributeDescription.CLIP_HEIGHT),
    FIELD_WIDTH("width", null, Integer.class, IntegerOption.class, true, AttributeDescription.WIDTH),
    FIELD_HEIGHT("height", null, Integer.class, IntegerOption.class, true, AttributeDescription.HEIGHT),
    TABLE_WIDTH("table-width", null, Size.class, SizeOption.class, false, AttributeDescription.TABLE_WIDTH, new Example[]{Example.TABLE_1}),
    TABLE_HEIGHT("table-height", null, Size.class, SizeOption.class, false, AttributeDescription.TABLE_HEIGHT, new Example[]{Example.TABLE_1}),
    TABLE_BORDER("table-border", 1, Integer.class, IntegerOption.class, false, AttributeDescription.TABLE_BORDER, new Example[]{Example.TABLE_1}),
    HEADER_BORDER("header-border", 2, Integer.class, IntegerOption.class, false, AttributeDescription.HEADER_BORDER, new Example[]{Example.TABLE_1}),
    HEADER_ROW("header-row", false, Boolean.class, BooleanOption.class, false, AttributeDescription.HEADER_ROW, new Example[]{Example.TABLE_1}),
    HEADER_COLUMN("header-column", false, Boolean.class, BooleanOption.class, false, AttributeDescription.HEADER_COLUMN, new Example[]{Example.TABLE_1}),
    MAX_HEIGHT("max-height", null, Integer.class, IntegerOption.class, false, AttributeDescription.MAX_HEIGHT, new Example[]{Example.RELATIVE_1, Example.EXAMPLE_NESTED_FIELDS}),
    X("x", null, Integer.class, IntegerOption.class, false, AttributeDescription.X),
    Y("y", null, Integer.class, IntegerOption.class, false, AttributeDescription.Y),
    OUTLINE("outline", false, Boolean.class, BooleanOption.class, true, AttributeDescription.OUTLINE),
    OUTLINE_THICKNESS("outline-thickness", 1, Integer.class, IntegerOption.class, true, AttributeDescription.OUTLINE_THICKNESS),
    OUTLINE_COLOR("outline-color", Color.BLACK, Color.class, ColorOption.class, true, AttributeDescription.OUTLINE_COLOR),
    OUTLINE_INSIDE("outline-inside", false, Boolean.class, BooleanOption.class, true, AttributeDescription.OUTLINE_INSIDE),
    SHADOW("shadow", false, Boolean.class, BooleanOption.class, true, AttributeDescription.SHADOW),
    SHADOW_COLOR("shadow-color", Color.BLACK, Color.class, ColorOption.class, true, AttributeDescription.SHADOW_COLOR),
    SHADOW_SIZE("shadow-size", 2, Integer.class, IntegerOption.class, true, AttributeDescription.SHADOW_SIZE),
    SHADOW_ALPHA("shadow-alpha", 0.5, Double.class, DoubleOption.class, true, AttributeDescription.SHADOW_ALPHA),
    SHADOW_BLUR("shadow-blur", false, Boolean.class, BooleanOption.class, true, AttributeDescription.SHADOW_BLUR),
    FONT_FAMILY("font-family", "Arial", String.class, StringOption.class, true, AttributeDescription.FONT_FAMILY),
    FONT_STYLE("font-style", TextElement.FontStyle.NORMAL, true, AttributeDescription.FONT_STYLE),
    FONT_WEIGHT("font-weight", TextElement.FontWeight.NORMAL, true, AttributeDescription.FONT_WEIGHT),
    TEXT_DECORATION("text-decoration", TextElement.TextDecoration.NONE, true, AttributeDescription.TEXT_DECORATION, new Example[]{Example.SPAN_1}),
    SUPERSCRIPT("superscript", SuperScript.NORMAL, true, AttributeDescription.SUPERSCRIPT, new Example[]{Example.SPAN_1}),
    FONT_SIZE("font-size", new Integer[]{12}, Integer[].class, DescendingIntegerArrayOption.class, true, AttributeDescription.FONT_SIZE),
    CONDENSE_FACTOR("condense", new Double[]{1.0}, Double[].class, DescendingDoubleArrayOption.class, true, AttributeDescription.CONDENSE, new Example[]{Example.SPAN_1}),
    LETTER_SPACING("letter-spacing", 0.0, Double.class, DoubleOption.class, true, AttributeDescription.LETTER_SPACING, new Example[]{Example.MULTI_LINE}),
    LINE_SPACING("line-spacing", 0, Integer.class, IntegerOption.class, true, AttributeDescription.LINE_SPACING, new Example[]{Example.LIST_1}),
    WRAPPED_LINE_SPACING("wrapped-line-spacing", 0, Integer.class, IntegerOption.class, true, AttributeDescription.WRAPPED_LINE_SPACING, new Example[]{Example.LIST_1}),
    PADDING_TOP("padding-top", 0, Integer.class, IntegerOption.class, true, AttributeDescription.PADDING_TOP),
    PADDING_RIGHT("padding-right", 0, Integer.class, IntegerOption.class, true, AttributeDescription.PADDING_RIGHT),
    PADDING_BOTTOM("padding-bottom", 0, Integer.class, IntegerOption.class, true, AttributeDescription.PADDING_BOTTOM),
    PADDING_LEFT("padding-left", 0, Integer.class, IntegerOption.class, true, AttributeDescription.PADDING_LEFT),
    SPACING("spacing", null, Integer.class, IntegerOption.class, false, AttributeDescription.SPACING, new Example[]{Example.LIST_1}),
    CELL_PADDING("cellpadding", 2, Integer.class, IntegerOption.class, true, AttributeDescription.CELLPADDING),
    FLOAT("float", false, Boolean.class, BooleanOption.class, false, AttributeDescription.FLOAT),
    ALIGNMENT("align", Alignment.LEFT, true, AttributeDescription.ALIGNMENT),
    VERTICAL_ALIGNMENT("valign", VerticalAlignment.TOP, true, AttributeDescription.VERTICAL_ALIGNMENT),
    BACKGROUND_IMAGE("background-image", null, String.class, StringOption.class, false, AttributeDescription.BACKGROUND_IMAGE),
    ROTATION("rotation", 0, Integer.class, IntegerOption.class, false, AttributeDescription.ROTATION),
    ROTATION_ANGLE("rotation", 0, Integer.class, IntegerOption.class, false, AttributeDescription.ROTATION_ANGLE, new Example[]{Example.ROTATION_1}),
    INVERT("invert", false, Boolean.class, BooleanOption.class, false, AttributeDescription.INVERT),
    BORDER("border", 0, Integer.class, IntegerOption.class, false, AttributeDescription.BORDER, new Example[]{Example.DRAWING_1}),
    BORDER_COLOR("border-color", Color.black, Color.class, ColorOption.class, false, AttributeDescription.BORDER_COLOR),
    BORDER_STYLE("border-style", BorderStyle.SOLID, false, AttributeDescription.BORDER_STYLE),
    FILL("fill", true, Boolean.class, BooleanOption.class, false, AttributeDescription.FILL),
    X_FROM("x-from", null, Integer.class, IntegerOption.class, false, AttributeDescription.X_FROM, new Example[]{Example.DRAWING_1}),
    Y_FROM("y-from", null, Integer.class, IntegerOption.class, false, AttributeDescription.Y_FROM, new Example[]{Example.DRAWING_1}),
    X_TO("x-to", null, Integer.class, IntegerOption.class, false, AttributeDescription.X_TO, new Example[]{Example.DRAWING_1}),
    Y_TO("y-to", null, Integer.class, IntegerOption.class, false, AttributeDescription.Y_TO, new Example[]{Example.DRAWING_1}),
    X1("x1", null, Integer.class, IntegerOption.class, false, AttributeDescription.TRIANGLE_COORDINATE, new Example[]{Example.DRAWING_2}),
    X2("x2", null, Integer.class, IntegerOption.class, false, AttributeDescription.TRIANGLE_COORDINATE, new Example[]{Example.DRAWING_2}),
    X3("x3", null, Integer.class, IntegerOption.class, false, AttributeDescription.TRIANGLE_COORDINATE, new Example[]{Example.DRAWING_2}),
    Y1("y1", null, Integer.class, IntegerOption.class, false, AttributeDescription.TRIANGLE_COORDINATE, new Example[]{Example.DRAWING_2}),
    Y2("y2", null, Integer.class, IntegerOption.class, false, AttributeDescription.TRIANGLE_COORDINATE, new Example[]{Example.DRAWING_2}),
    Y3("y3", null, Integer.class, IntegerOption.class, false, AttributeDescription.TRIANGLE_COORDINATE, new Example[]{Example.DRAWING_2}),
    POINTS("points", null, Point[].class, UnorderedPointArrayOption.class, false, AttributeDescription.POLYGON_COORDINATES, new Example[]{Example.DRAWING_2}),
    CORNER_RADIUS("corner-radius", 0, Integer.class, IntegerOption.class, false, AttributeDescription.CORNER_RADIUS, new Example[]{Example.DRAWING_3}),
    ROUNDED_CORNERS("rounded-corners", RoundedCorner.class, (Enum[])new RoundedCorner[0], false, AttributeDescription.ROUNDED_CORNERS, new Example[]{Example.DRAWING_3}),
    THICKNESS("thickness", 1, Integer.class, IntegerOption.class, false, AttributeDescription.THICKNESS),
    BULLET_TYPE_OL("type", ".", String.class, StringOption.class, false, AttributeDescription.BULLET_TYPE, new Example[]{Example.LIST_1}),
    BULLET_TYPE_UL("type", "dash", String.class, StringOption.class, false, AttributeDescription.BULLET_TYPE, new Example[]{Example.LIST_1}),
    BULLET_IMAGE("bullet-image", null, String.class, StringOption.class, false, AttributeDescription.BULLET_IMAGE, new Example[]{Example.LIST_1}),
    BULLET_FONT_FAMILY("bullet-font-family", null, String.class, StringOption.class, false, AttributeDescription.BULLET_FONT_FAMILY, new Example[]{Example.LIST_1}),
    SOURCE("src", null, String.class, StringOption.class, false, AttributeDescription.SOURCE, new Example[]{Example.IMAGE_1}),
    DATA("data", null, String.class, StringOption.class, false, AttributeDescription.DATA, new Example[]{Example.IMAGE_1}),
    FONT_SIZE_PT("fontSizePt", 6, Integer.class, IntegerOption.class, false, AttributeDescription.FONT_SIZE),
    FONT_NAME("fontName", "Helvetica", String.class, StringOption.class, false, AttributeDescription.FONT_NAME),
    PDF417_QUIET_ZONE_FACTOR("quietZoneFactor", 2, Integer.class, IntegerOption.class, false, AttributeDescription.QUIET_ZONE_FACTOR),
    QUIET_ZONE_FACTOR("quietZoneFactor", 10, Integer.class, IntegerOption.class, false, AttributeDescription.QUIET_ZONE_FACTOR),
    DATAMATRIX_QUIET_ZONE_FACTOR("quietZoneFactor", 1, Integer.class, IntegerOption.class, false, AttributeDescription.QUIET_ZONE_FACTOR),
    VERTICAL_QUIET_ZONE_FACTOR("verticalQuietZoneFactor", 6, Integer.class, IntegerOption.class, false, AttributeDescription.VERTICAL_QUIET_ZONE_FACTOR),
    QUIET_ZONE_ENABLED("quietZoneEnabled", false, Boolean.class, BooleanOption.class, false, AttributeDescription.QUIET_ZONE_ENABLED),
    DATAMATRIX_QUIET_ZONE_ENABLED("quietZoneEnabled", true, Boolean.class, BooleanOption.class, false, AttributeDescription.QUIET_ZONE_ENABLED),
    PDF417_QUIET_ZONE_ENABLED("quietZoneEnabled", true, Boolean.class, BooleanOption.class, false, AttributeDescription.QUIET_ZONE_ENABLED),
    HUMAN_READABLE_ENABLED("humanReadableEnabled", true, Boolean.class, BooleanOption.class, false, AttributeDescription.HUMAN_READABLE_ENABLED),
    HUMAN_READABLE_PLACEMENT("humanReadablePlacement", Barcode1D.DEFAULT_HUMAN_READABLE_PLACEMENT, false, AttributeDescription.HUMAN_READABLE_PLACEMENT),
    SCALE("scale", 1, Integer.class, IntegerOption.class, false, AttributeDescription.SCALE),
    QR_SCALE("scale", 2, Integer.class, IntegerOption.class, false, AttributeDescription.SCALE),
    DATAMATRIX_SCALE("scale", 1, Integer.class, IntegerOption.class, false, AttributeDescription.SCALE),
    PDF417_SCALE("scale", 1, Integer.class, IntegerOption.class, false, AttributeDescription.SCALE),
    AUTOSCALE("autoscale", false, Boolean.class, BooleanOption.class, false, AttributeDescription.AUTO_SCALE),
    QR_AUTOSCALE("autoscale", false, Boolean.class, BooleanOption.class, false, AttributeDescription.AUTO_SCALE),
    DATAMATRIX_AUTOSCALE("autoscale", false, Boolean.class, BooleanOption.class, false, AttributeDescription.AUTO_SCALE),
    QR_PADDED("padded", false, Boolean.class, BooleanOption.class, false, AttributeDescription.PADDED),
    PDF417_PADDED("padded", false, Boolean.class, BooleanOption.class, false, AttributeDescription.PADDED),
    DATAMATRIX_PADDED("padded", false, Boolean.class, BooleanOption.class, false, AttributeDescription.PADDED),
    EAN8_CHECKSUM_MODE("checksumMode", EAN8Code.DEFAULT_CHECKSUM_MODE, false, AttributeDescription.CHECKSUM_MODE),
    EAN13_CHECKSUM_MODE("checksumMode", EAN13Code.DEFAULT_CHECKSUM_MODE, false, AttributeDescription.CHECKSUM_MODE),
    CODE39_CHECKSUM_MODE("checksumMode", Code39Code.DEFAULT_CHECKSUM_MODE, false, AttributeDescription.CHECKSUM_MODE),
    UPCA_CHECKSUM_MODE("checksumMode", UPCACode.DEFAULT_CHECKSUM_MODE, false, AttributeDescription.CHECKSUM_MODE),
    UPCE_CHECKSUM_MODE("checksumMode", UPCECode.DEFAULT_CHECKSUM_MODE, false, AttributeDescription.CHECKSUM_MODE),
    INTL2OF5_CHECKSUM_MODE("checksumMode", Intl2of5Code.DEFAULT_CHECKSUM_MODE, false, AttributeDescription.CHECKSUM_MODE),
    ITF14_CHECKSUM_MODE("checksumMode", ITF14Code.DEFAULT_CHECKSUM_MODE, false, AttributeDescription.CHECKSUM_MODE),
    ERROR_CORRECTION_LEVEL("errorCorrectionLevel", QRCode.DEFAULT_ERROR_CORRECTION_LEVEL, false, AttributeDescription.ERROR_CORRECTION_LEVEL),
    ROW_HEIGHT_RATIO("rowHeightRatio", 3.0, Double.class, DoubleOption.class, false, AttributeDescription.ROW_HEIGHT_RATIO),
    COLUMNS("columns", 0, Integer.class, IntegerOption.class, false, AttributeDescription.COLUMNS),
    MIN_COLUMNS("minColumns", 2, Integer.class, IntegerOption.class, false, AttributeDescription.MIN_COLUMNS),
    MAX_COLUMNS("maxColumns", 2, Integer.class, IntegerOption.class, false, AttributeDescription.MAX_COLUMNS),
    MIN_ROWS("minRows", 3, Integer.class, IntegerOption.class, false, AttributeDescription.MIN_ROWS),
    MAX_ROWS("maxRows", 90, Integer.class, IntegerOption.class, false, AttributeDescription.MIN_ROWS),
    EC_LEVEL("ecLevel", 0, Integer.class, IntegerOption.class, false, AttributeDescription.MIN_ROWS),
    WIDTH_TO_HEIGHT_RATIO("widthToHeightRatio", 3.0, Double.class, DoubleOption.class, false, AttributeDescription.WIDTH_TO_HEIGHT_RATIO),
    BEARER_BAR_WIDTH("bearerBarWidth", 20, Integer.class, IntegerOption.class, false, AttributeDescription.BEARER_BAR_WIDTH),
    BEARER_BOX("bearerBox", true, Boolean.class, BooleanOption.class, false, AttributeDescription.BEARER_BAR_WIDTH),
    ITF14_WIDE_FACTOR("wideFactor", 2.0, Double.class, DoubleOption.class, false, AttributeDescription.WIDE_FACTOR),
    INTL2OF5_WIDE_FACTOR("wideFactor", 3.0, Double.class, DoubleOption.class, false, AttributeDescription.WIDE_FACTOR),
    ITF14_DISPLAY_CHECKSUM("displayChecksum", false, Boolean.class, BooleanOption.class, false, AttributeDescription.DISPLAY_CHECKSUM),
    INTL2OF5_DISPLAY_CHECKSUM("displayChecksum", false, Boolean.class, BooleanOption.class, false, AttributeDescription.DISPLAY_CHECKSUM),
    CODE39_DISPLAY_CHECKSUM("displayChecksum", false, Boolean.class, BooleanOption.class, false, AttributeDescription.DISPLAY_CHECKSUM),
    TEMPLATE("template", "", String.class, StringOption.class, false, AttributeDescription.TEMPLATE),
    OMIT_BRACKETS("omitBrackets", false, Boolean.class, BooleanOption.class, false, AttributeDescription.OMIT_BRACKETS),
    CODABAR_DISPLAY_START_STOP("displayStartStop", false, Boolean.class, BooleanOption.class, false, AttributeDescription.DISPLAY_START_STOP),
    CODE39DISPLAY_START_STOP("displayStartStop", false, Boolean.class, BooleanOption.class, false, AttributeDescription.DISPLAY_START_STOP),
    INTERCHAR_GAP_WIDTH("intercharGapWidth", 1, Integer.class, IntegerOption.class, false, AttributeDescription.INTERCHAR_GAP_WIDTH),
    EXTENDED_CHARSET("extendedCharset", false, Boolean.class, BooleanOption.class, false, AttributeDescription.EXTENDED_CHARSET),
    CODESETS("codesets", "ABC", String.class, StringOption.class, false, AttributeDescription.CODESETS),
    AUTO_MODE("autoMode", true, Boolean.class, BooleanOption.class, false, AttributeDescription.AUTO_MODE),
    SHAPE("shape", DataMatrixCode.DEFAULT_SHAPE, false, AttributeDescription.SHAPE),
    MIN_SYMBOL_SIZE_WIDTH("minSymbolSizeWidth", 1, Integer.class, IntegerOption.class, false, AttributeDescription.MIN_SYMBOL_SIZE_WIDTH),
    MIN_SYMBOL_SIZE_HEIGHT("minSymbolSizeHeight", 1, Integer.class, IntegerOption.class, false, AttributeDescription.MIN_SYMBOL_SIZE_HEIGHT),
    MAX_SYMBOL_SIZE_WIDTH("maxSymbolSizeWidth", 0, Integer.class, IntegerOption.class, false, AttributeDescription.MAX_SYMBOL_SIZE_WIDTH),
    MAX_SYMBOL_SIZE_HEIGHT("maxSymbolSizeHeight", 1, Integer.class, IntegerOption.class, false, AttributeDescription.MAX_SYMBOL_SIZE_HEIGHT),
    BARCODE_TYPE("type", null, String.class, StringOption.class, false, AttributeDescription.BARCODE_TYPE),
    WRAP("wrap", LineWrap.NORMAL, true, AttributeDescription.WRAP),
    CUT_LEFT("cut-left", 0, Integer.class, IntegerOption.class, false, AttributeDescription.CUT_LEFT, new Example[0]),
    CUT_RIGHT("cut-right", 0, Integer.class, IntegerOption.class, false, AttributeDescription.CUT_RIGHT, new Example[0]),
    CUT_TOP("cut-top", 0, Integer.class, IntegerOption.class, false, AttributeDescription.CUT_TOP, new Example[0]),
    CUT_BOTTOM("cut-bottom", 0, Integer.class, IntegerOption.class, false, AttributeDescription.CUT_BOTTOM, new Example[0]);

    private final String key;
    private final Object defaultValue;
    private final Class<?> optionClass;
    private final boolean inheritate;
    private final boolean isEnum;
    private final Class<?> valueClass;
    private final AttributeDescription description;
    private final Example[] examples;

    private <T extends Enum<?>> Attribute(String key, T defaultValue, boolean inheritate, AttributeDescription description) {
        this(key, defaultValue, defaultValue.getClass(), EnumOption.class, inheritate, description, true, null);
    }

    private <T> Attribute(String key, T defaultValue, Class<T> valueClass, Class<? extends Option<T>> optionClass, boolean inheritate, AttributeDescription description) {
        this(key, defaultValue, valueClass, optionClass, inheritate, description, false, null);
    }

    private <T extends Enum<?>> Attribute(String key, T defaultValue, boolean inheritate, AttributeDescription description, Example[] examples) {
        this(key, defaultValue, defaultValue.getClass(), EnumOption.class, inheritate, description, true, examples);
    }

    private <T extends Enum<?>> Attribute(String key, Class<T> valueClass, T[] defaultValue, boolean inheritate, AttributeDescription description, Example[] examples) {
        this(key, defaultValue, valueClass, UnorderedEnumArrayOption.class, inheritate, description, true, examples);
    }

    private <T> Attribute(String key, T defaultValue, Class<T> valueClass, Class<? extends Option<T>> optionClass, boolean inheritate, AttributeDescription description, Example[] examples) {
        this(key, defaultValue, valueClass, optionClass, inheritate, description, false, examples);
    }

    private <T> Attribute(String key, T defaultValue, Class<?> valueClass, Class<?> optionClass, boolean inheritate, AttributeDescription description, boolean isEnum, Example[] examples) {
        this.isEnum = isEnum;
        this.key = key;
        this.defaultValue = defaultValue;
        this.optionClass = optionClass;
        this.inheritate = inheritate;
        this.valueClass = valueClass;
        this.description = description;
        this.examples = examples;
    }

    public AttributeDescription getDescription() {
        return this.description;
    }

    public boolean isInheritate() {
        return this.inheritate;
    }

    public String getKey() {
        return this.key;
    }

    public String getDefaultValue() throws SecurityException, IllegalArgumentException, OptionException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        return this.createOption().getDefaultValueAsString();
    }

    public Option<?> createOption() throws SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        if (this.isEnum) {
            if (this.defaultValue.getClass().isArray()) {
                Constructor<?> constructor = this.optionClass.getConstructor(String.class, Enum[].class, Class.class);
                return (Option)constructor.newInstance(this.key, this.defaultValue, this.valueClass);
            }
            Constructor<?> constructor = this.optionClass.getConstructor(String.class, Enum.class, Class.class);
            return (Option)constructor.newInstance(this.key, this.defaultValue, this.defaultValue.getClass());
        }
        Constructor<?> constructor = this.optionClass.getConstructor(String.class, this.valueClass);
        return (Option)constructor.newInstance(this.key, this.defaultValue);
    }

    public Example[] getExamples() {
        return this.examples;
    }

    public Class<?> getValueClass() {
        return this.valueClass;
    }
}

