/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.collection;

import com.google.common.base.Preconditions;
import java.util.Iterator;
import java.util.List;

public class PartitionedListIterator<E>
implements Iterator<List<E>> {
    private final List<E> list;
    private final int partitionSize;
    private int lastIndex = 0;

    public static <E> Iterable<List<E>> createPartitions(final List<E> list, final int partitionSize) {
        return new Iterable<List<E>>(){

            @Override
            public Iterator<List<E>> iterator() {
                return new PartitionedListIterator(list, partitionSize);
            }
        };
    }

    private PartitionedListIterator(List<E> list, int partitionSize) {
        Preconditions.checkArgument((partitionSize > 0 ? 1 : 0) != 0, (Object)"Invalid partition size - must be larger than zero");
        this.list = list;
        this.partitionSize = partitionSize;
    }

    @Override
    public boolean hasNext() {
        return this.lastIndex < this.list.size();
    }

    @Override
    public List<E> next() {
        int beginIndex = this.lastIndex;
        int endIndex = 0;
        endIndex = this.lastIndex + this.partitionSize > this.list.size() ? this.list.size() : this.lastIndex + this.partitionSize;
        this.lastIndex = endIndex;
        return this.list.subList(beginIndex, endIndex);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

