/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.camera;

import com.lti.civil.CaptureException;
import com.lti.civil.CaptureStream;
import com.lti.civil.VideoFormat;

public class CivilUtils {
    public static void setVideoFormat(CaptureStream captureStream, int minimumWidth) throws CaptureException {
        for (VideoFormat format : captureStream.enumVideoFormats()) {
            if (format.getWidth() < minimumWidth) continue;
            captureStream.setVideoFormat(format);
            return;
        }
    }

    public static String videoFormatToString(VideoFormat f) {
        return "Type=" + CivilUtils.formatTypeToString(f.getFormatType()) + " Width=" + f.getWidth() + " Height=" + f.getHeight() + " FPS=" + f.getFPS();
    }

    public static String formatTypeToString(int f) {
        switch (f) {
            case 1: {
                return "RGB24";
            }
            case 2: {
                return "RGB32";
            }
        }
        return "" + f + " (unknown)";
    }

    private CivilUtils() {
    }
}

