/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.barcodescanner.image;

import at.mrdevelopment.toolkit.barcode.Barcode;
import at.mrdevelopment.toolkit.barcode.Barcode1D;
import at.mrdevelopment.toolkit.barcode.specific.CodabarCode;
import at.mrdevelopment.toolkit.barcode.specific.Code128Code;
import at.mrdevelopment.toolkit.barcode.specific.Code39Code;
import at.mrdevelopment.toolkit.barcode.specific.DataMatrixCode;
import at.mrdevelopment.toolkit.barcode.specific.EAN128Code;
import at.mrdevelopment.toolkit.barcode.specific.EAN8Code;
import at.mrdevelopment.toolkit.barcode.specific.ITF14Code;
import at.mrdevelopment.toolkit.barcode.specific.Intl2of5Code;
import at.mrdevelopment.toolkit.barcode.specific.PDF417Code;
import at.mrdevelopment.toolkit.barcode.specific.PostnetCode;
import at.mrdevelopment.toolkit.barcode.specific.QRCode;
import at.mrdevelopment.toolkit.barcode.specific.RoyalMailCBCCode;
import at.mrdevelopment.toolkit.barcode.specific.UPCACode;
import at.mrdevelopment.toolkit.barcode.specific.UPCECode;
import at.mrdevelopment.toolkit.barcode.specific.USPS4CBCode;
import at.mrdevelopment.toolkit.barcodescanner.Scan;
import at.mrdevelopment.toolkit.barcodescanner.image.BufferedImageLuminanceSource;
import com.google.zxing.Binarizer;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.DecodeHintType;
import com.google.zxing.LuminanceSource;
import com.google.zxing.MultiFormatReader;
import com.google.zxing.Reader;
import com.google.zxing.ReaderException;
import com.google.zxing.Result;
import com.google.zxing.common.HybridBinarizer;
import com.google.zxing.datamatrix.DataMatrixReader;
import com.google.zxing.multi.GenericMultipleBarcodeReader;
import com.google.zxing.multi.MultipleBarcodeReader;
import com.google.zxing.multi.qrcode.QRCodeMultiReader;
import com.google.zxing.oned.CodaBarReader;
import com.google.zxing.oned.Code128Reader;
import com.google.zxing.oned.Code39Reader;
import com.google.zxing.oned.EAN8Reader;
import com.google.zxing.oned.ITFReader;
import com.google.zxing.oned.MultiFormatOneDReader;
import com.google.zxing.oned.MultiFormatUPCEANReader;
import com.google.zxing.oned.UPCAReader;
import com.google.zxing.oned.UPCEReader;
import com.google.zxing.pdf417.PDF417Reader;
import com.google.zxing.qrcode.QRCodeReader;
import java.awt.image.BufferedImage;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import javax.imageio.ImageIO;

public class BarcodeImageScanner {
    private static final boolean DEFAULT_SCAN_MULTIPLE = true;
    private final boolean scanMultipleBarcodesAtOnce;
    private final Class<? extends Barcode> barcodeClass;

    public static void main(String[] args) {
        try {
            List<Scan> scanBarcodes = new BarcodeImageScanner(QRCode.class).scan("C:\\Users\\cprettenthaler.LNC\\Desktop\\QR_Scan_Test_01.png");
            System.out.println(scanBarcodes.size());
            for (Scan scan : scanBarcodes) {
                System.out.println(scan.getData());
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static BarcodeImageScanner createQrCodeScanner() {
        return new BarcodeImageScanner(QRCode.class);
    }

    public BarcodeImageScanner(Class<? extends Barcode> barcodeClass) {
        this(barcodeClass, true);
    }

    public BarcodeImageScanner(Class<? extends Barcode> barcodeClass, boolean scanMultipleBarcodesAtOnce) {
        this.barcodeClass = barcodeClass;
        this.scanMultipleBarcodesAtOnce = scanMultipleBarcodesAtOnce;
    }

    public boolean isScanMultipleBarcodesAtOnce() {
        return this.scanMultipleBarcodesAtOnce;
    }

    public Class<? extends Barcode> getBarcodeClass() {
        return this.barcodeClass;
    }

    public List<Scan> scan(URL url) throws IOException {
        URLConnection imageConnection = url.openConnection();
        return this.scan(imageConnection.getInputStream());
    }

    public List<Scan> scan(String fileName) throws FileNotFoundException, IOException {
        return this.scan(new FileInputStream(fileName));
    }

    public List<Scan> scan(InputStream inputStream) throws IOException {
        return this.scan(ImageIO.read(inputStream));
    }

    public List<Scan> scan(BufferedImage image) {
        return this.isScanMultipleBarcodesAtOnce() ? this.scanMultiple(image) : this.scanSingle(image);
    }

    private List<Scan> scanSingle(BufferedImage image) {
        BufferedImageLuminanceSource source = new BufferedImageLuminanceSource(image);
        BinaryBitmap bitmap = new BinaryBitmap((Binarizer)new HybridBinarizer((LuminanceSource)source));
        Reader reader = this.createSingleReader();
        Result result = null;
        try {
            result = reader.decode(bitmap);
        }
        catch (ReaderException e) {
            return null;
        }
        Scan scan = new Scan(result.getTimestamp(), result.getText(), result.getBarcodeFormat().getName(), image);
        if (image != null) {
            image.flush();
            image = null;
            System.gc();
        }
        return Collections.singletonList(scan);
    }

    private Reader createSingleReader() {
        if (this.getBarcodeClass().equals(QRCode.class)) {
            return new QRCodeReader();
        }
        if (this.getBarcodeClass().equals(CodabarCode.class)) {
            return new CodaBarReader();
        }
        if (this.getBarcodeClass().equals(Code128Code.class)) {
            return new Code128Reader();
        }
        if (this.getBarcodeClass().equals(Code39Code.class)) {
            return new Code39Reader();
        }
        if (this.getBarcodeClass().equals(DataMatrixCode.class)) {
            return new DataMatrixReader();
        }
        if (this.getBarcodeClass().equals(EAN8Code.class)) {
            return new EAN8Reader();
        }
        if (this.getBarcodeClass().equals(ITF14Code.class)) {
            return new ITFReader();
        }
        if (this.getBarcodeClass().equals(PDF417Code.class)) {
            return new PDF417Reader();
        }
        if (this.getBarcodeClass().equals(UPCACode.class)) {
            return new UPCAReader();
        }
        if (this.getBarcodeClass().equals(UPCECode.class)) {
            return new UPCEReader();
        }
        if (this.getBarcodeClass().equals(Barcode1D.class)) {
            return new MultiFormatReader();
        }
        if (this.getBarcodeClass().equals(Barcode.class)) {
            return new MultiFormatReader();
        }
        return new MultiFormatReader();
    }

    private List<Scan> scanMultiple(BufferedImage image) {
        BufferedImageLuminanceSource source = new BufferedImageLuminanceSource(image);
        BinaryBitmap bitmap = new BinaryBitmap((Binarizer)new HybridBinarizer((LuminanceSource)source));
        MultipleBarcodeReader multipleBarcodeReader = this.createMultipleBarcodeReader();
        Result[] results = null;
        ArrayList<Scan> scanResults = new ArrayList<Scan>();
        try {
            results = multipleBarcodeReader.decodeMultiple(bitmap, this.createHints());
        }
        catch (ReaderException e) {
            scanResults.add(new Scan(System.currentTimeMillis(), "no scan", "no type", image));
            return scanResults;
        }
        for (Result result : results) {
            Scan scan = new Scan(result.getTimestamp(), result.getText(), result.getBarcodeFormat().getName(), image);
            scanResults.add(scan);
        }
        if (scanResults.isEmpty()) {
            scanResults.add(new Scan(System.currentTimeMillis(), "no scan", "no type", image));
        }
        if (image != null) {
            image.flush();
            image = null;
        }
        return scanResults;
    }

    private Hashtable<DecodeHintType, Object> createHints() {
        Hashtable<DecodeHintType, Object> hints = new Hashtable<DecodeHintType, Object>();
        hints.put(DecodeHintType.TRY_HARDER, Boolean.TRUE);
        return hints;
    }

    private MultipleBarcodeReader createMultipleBarcodeReader() {
        if (this.getBarcodeClass().equals(QRCode.class)) {
            return new QRCodeMultiReader();
        }
        if (this.getBarcodeClass().equals(CodabarCode.class)) {
            return new GenericMultipleBarcodeReader((Reader)new MultiFormatOneDReader(this.createHints()));
        }
        if (this.getBarcodeClass().equals(Code128Code.class)) {
            return new GenericMultipleBarcodeReader((Reader)new MultiFormatOneDReader(this.createHints()));
        }
        if (this.getBarcodeClass().equals(Code39Code.class)) {
            return new GenericMultipleBarcodeReader((Reader)new MultiFormatOneDReader(this.createHints()));
        }
        if (this.getBarcodeClass().equals(DataMatrixCode.class)) {
            return new GenericMultipleBarcodeReader((Reader)new DataMatrixReader());
        }
        if (this.getBarcodeClass().equals(EAN128Code.class)) {
            return new GenericMultipleBarcodeReader((Reader)new MultiFormatUPCEANReader(this.createHints()));
        }
        if (this.getBarcodeClass().equals(EAN8Code.class)) {
            return new GenericMultipleBarcodeReader((Reader)new MultiFormatUPCEANReader(this.createHints()));
        }
        if (this.getBarcodeClass().equals(Intl2of5Code.class)) {
            return new GenericMultipleBarcodeReader((Reader)new MultiFormatOneDReader(this.createHints()));
        }
        if (this.getBarcodeClass().equals(ITF14Code.class)) {
            return new GenericMultipleBarcodeReader((Reader)new MultiFormatOneDReader(this.createHints()));
        }
        if (this.getBarcodeClass().equals(PDF417Code.class)) {
            return new GenericMultipleBarcodeReader((Reader)new MultiFormatOneDReader(this.createHints()));
        }
        if (this.getBarcodeClass().equals(PostnetCode.class)) {
            return new GenericMultipleBarcodeReader((Reader)new MultiFormatOneDReader(this.createHints()));
        }
        if (this.getBarcodeClass().equals(RoyalMailCBCCode.class)) {
            return new GenericMultipleBarcodeReader((Reader)new MultiFormatOneDReader(this.createHints()));
        }
        if (this.getBarcodeClass().equals(UPCACode.class)) {
            return new GenericMultipleBarcodeReader((Reader)new MultiFormatUPCEANReader(this.createHints()));
        }
        if (this.getBarcodeClass().equals(UPCECode.class)) {
            return new GenericMultipleBarcodeReader((Reader)new MultiFormatUPCEANReader(this.createHints()));
        }
        if (this.getBarcodeClass().equals(USPS4CBCode.class)) {
            return new GenericMultipleBarcodeReader((Reader)new MultiFormatOneDReader(this.createHints()));
        }
        if (this.getBarcodeClass().equals(Barcode1D.class)) {
            return new GenericMultipleBarcodeReader((Reader)new MultiFormatOneDReader(this.createHints()));
        }
        if (this.getBarcodeClass().equals(Barcode.class)) {
            return new GenericMultipleBarcodeReader((Reader)new MultiFormatReader());
        }
        return new GenericMultipleBarcodeReader((Reader)new MultiFormatReader());
    }
}

