/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.barcodescanner.camera;

import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.barcodescanner.AbstractBarcodeScanner;
import at.mrdevelopment.toolkit.barcodescanner.Scan;
import at.mrdevelopment.toolkit.barcodescanner.image.BarcodeImageScanner;
import at.mrdevelopment.toolkit.camera.CameraCivil;
import at.mrdevelopment.toolkit.camera.CameraException;
import at.mrdevelopment.toolkit.camera.CameraObserver;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.awt.image.BufferedImage;
import java.util.Collection;
import java.util.List;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;

public class CivilCameraBarcodeScanner
extends AbstractBarcodeScanner
implements CameraObserver {
    private static final Integer DEFAULT_DEVICE_ID = 0;
    static ESLLogger logger;
    private CameraCivil camera;
    private BarcodeImageScanner barcodeImageScanner = BarcodeImageScanner.createQrCodeScanner();

    public CivilCameraBarcodeScanner(int deviceId) throws InitializationException {
        this.camera = new CameraCivil(deviceId);
        try {
            this.camera.start();
        }
        catch (CameraException exc) {
            logger.logException(exc);
            throw new InitializationException(exc);
        }
    }

    @Override
    public Collection<Scan> scanBarcodes() {
        if (this.camera == null) {
            return null;
        }
        BufferedImage image = this.camera.getLatestImage();
        if (image != null) {
            List<Scan> scans = this.barcodeImageScanner.scan(image);
            return scans;
        }
        return null;
    }

    @Override
    public void onNewImage(BufferedImage image) {
    }

    public BufferedImage takePhoto() {
        return this.camera.getLatestImage();
    }

    public static void main(String[] args) {
        OptionParser parser = new OptionParser();
        ArgumentAcceptingOptionSpec optionId = parser.accepts("id", "Device id").withRequiredArg().ofType(Integer.class).defaultsTo((Object)DEFAULT_DEVICE_ID, (Object[])new Integer[0]);
        OptionSet options = parser.parse(args);
        int deviceId = options.has((OptionSpec)optionId) ? (Integer)options.valueOf((OptionSpec)optionId) : DEFAULT_DEVICE_ID;
        try {
            Collection<Scan> barcodes = new CivilCameraBarcodeScanner(deviceId).scanBarcodes();
            for (Scan scan : barcodes) {
                System.out.println(String.format("Type: %s, Data: %s", scan.getType(), scan.getData()));
            }
        }
        catch (InitializationException exc) {
            exc.printStackTrace();
            System.exit(1);
        }
    }

    static {
        ESLLogger.initLogger(true);
        logger = ESLLogger.getLogger(CivilCameraBarcodeScanner.class);
    }
}

