/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.barcodescanner;

import at.mrdevelopment.toolkit.image.ImageUtils;
import java.awt.image.BufferedImage;
import org.joda.time.DateTime;

public class Scan {
    private static BufferedImage noScanImage = ImageUtils.createImage(50, 50, 2);
    private final long time;
    private final String data;
    private final String type;
    private final BufferedImage image;

    public Scan(long time, String data, String type, BufferedImage image) {
        this.image = image;
        this.time = time;
        this.data = data;
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public long getTime() {
        return this.time;
    }

    public String getData() {
        return this.data;
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public static Scan getNoScan() {
        return new Scan(DateTime.now().getMillis(), "no scan", "no type", noScanImage);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.getClass().getSimpleName());
        builder.append(String.format(": time %d, data %s, type %s, image: %s", this.time, this.data, this.type, this.image != null ? this.image.toString() : "null"));
        return builder.toString();
    }
}

