/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.barcodescanner;

import at.mrdevelopment.toolkit.barcodescanner.Scan;
import at.mrdevelopment.toolkit.log.ESLLogger;
import org.joda.time.DateTime;

public class AwaitScan {
    static ESLLogger logger = ESLLogger.getLogger(AwaitScan.class);
    private String scanData;
    private boolean arrived = false;
    private Scan scan;

    public AwaitScan(String scanData) {
        this.scanData = scanData;
    }

    public void await() {
        this.arrived = false;
    }

    protected void reportScan(Scan scan) {
        if (!scan.getData().equals(this.scanData)) {
            logger.error("Mismatch between awaited scan [%s] and actual scan data [%s]", scan.getData(), this.scanData);
            return;
        }
        logger.info("Scan has arrived: [%s] at %s", this.scanData, new DateTime(scan.getTime()));
        this.scan = scan;
        this.arrived = true;
    }

    public boolean hasArrived() {
        return this.arrived;
    }

    public Scan getScan() {
        return this.scan;
    }
}

