/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.barcode.specific;

import at.mrdevelopment.toolkit.ExceptionElement;
import at.mrdevelopment.toolkit.ExecutionStatus;
import at.mrdevelopment.toolkit.barcode.Barcode;
import at.mrdevelopment.toolkit.barcode.BarcodeException;
import at.mrdevelopment.toolkit.barcode.BarcodeRenderingResult;
import at.mrdevelopment.toolkit.definition.TemplateElementType;
import at.mrdevelopment.toolkit.definition.TemplateNode;
import at.mrdevelopment.toolkit.image.ImageUtils;
import at.mrdevelopment.toolkit.options.Option;
import at.mrdevelopment.toolkit.options.OptionException;
import com.google.zxing.WriterException;
import com.google.zxing.qrcode.encoder.Encoder;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.Map;

@TemplateElementType(type=TemplateNode.BARCODE_QR)
public class QRCode
extends Barcode {
    public static final int DEFAULT_SCALE = 2;
    private static final int MINIMUM_SCALE = 1;
    public static final boolean DEFAULT_AUTOSCALE = false;
    public static final boolean DEFAULT_PADDED = false;
    public static final ErrorCorrectionLevel DEFAULT_ERROR_CORRECTION_LEVEL = ErrorCorrectionLevel.H;

    public QRCode() throws OptionException {
        super(QRCode.class);
    }

    public QRCode(Map<String, Option<?>> options) throws OptionException {
        super(options);
    }

    @Override
    public BarcodeRenderingResult render(String message, int maxWidthPx, int maxHeightPx) {
        BarcodeRenderingResult result;
        block17: {
            ExecutionStatus status = new ExecutionStatus();
            result = new BarcodeRenderingResult(this.createEmptyImage(maxWidthPx, maxHeightPx), status);
            if (message == null) {
                if (this.verbose) {
                    status.addElement(new ExceptionElement(new BarcodeException("Message to convert was null")));
                }
                result.setSuccessful(false);
            }
            try {
                int sizePx;
                if (!this.isAutoscale() && this.getScale() < 1) {
                    this.setScale(1);
                    result.setSuccessful(false);
                    if (this.verbose) {
                        ExceptionElement exceptionElement = new ExceptionElement(new BarcodeException("Scale is set lower than 1"));
                        status.addElement(exceptionElement);
                    }
                }
                com.google.zxing.qrcode.encoder.QRCode qrCode = new com.google.zxing.qrcode.encoder.QRCode();
                Encoder.encode((String)message, (com.google.zxing.qrcode.decoder.ErrorCorrectionLevel)this.toInternalErrorCorrectionLevel(this.getErrorCorrectionLevel()), (com.google.zxing.qrcode.encoder.QRCode)qrCode);
                BufferedImage resizedImage = null;
                int minSizePx = qrCode.getMatrixWidth();
                int maxSizePx = Math.min(maxWidthPx, maxHeightPx);
                BufferedImage image = ImageUtils.byteMatrixToImage(qrCode.getMatrix());
                if (this.isAutoscale()) {
                    sizePx = Math.min(maxWidthPx, maxHeightPx);
                    this.setScale((int)Math.max(1.0, Math.floor((double)sizePx / (double)minSizePx)));
                }
                sizePx = Math.round(minSizePx * this.getScale());
                resizedImage = ImageUtils.resize(image, sizePx, sizePx);
                if (sizePx > maxSizePx) {
                    if (this.verbose) {
                        status.addElement(new ExceptionElement(new BarcodeException("QR Code size exceeds maximum bounds")));
                    }
                    result.setSuccessful(false);
                    resizedImage = ImageUtils.clip(resizedImage, new Rectangle(Math.min(sizePx, maxWidthPx), Math.min(sizePx, maxHeightPx)), 2);
                } else if (resizedImage != null && this.isPadded()) {
                    BufferedImage wrapperImage = new BufferedImage(maxWidthPx, maxHeightPx, 12);
                    ImageUtils.fill(wrapperImage, Color.white);
                    ImageUtils.overlay(wrapperImage, resizedImage);
                    result.setImage(wrapperImage);
                    return result;
                }
                result.setImage(resizedImage);
                return result;
            }
            catch (WriterException e) {
                result.setSuccessful(false);
                if (this.verbose) {
                    status.addElement(new ExceptionElement(new BarcodeException(e.getMessage(), e.getCause())));
                }
            }
            catch (OptionException e) {
                result.setSuccessful(false);
                if (this.verbose) {
                    status.addElement(new ExceptionElement(new BarcodeException(e.getMessage(), e.getCause())));
                }
            }
            catch (BarcodeException e) {
                result.setSuccessful(false);
                if (this.verbose) {
                    status.addElement(new ExceptionElement(e));
                }
            }
            catch (Exception e) {
                result.setSuccessful(false);
                if (!this.verbose) break block17;
                status.addElement(new ExceptionElement(e));
            }
        }
        return result;
    }

    private com.google.zxing.qrcode.decoder.ErrorCorrectionLevel toInternalErrorCorrectionLevel(ErrorCorrectionLevel errorCorrectionLevel) throws BarcodeException {
        switch (errorCorrectionLevel) {
            case L: {
                return com.google.zxing.qrcode.decoder.ErrorCorrectionLevel.L;
            }
            case M: {
                return com.google.zxing.qrcode.decoder.ErrorCorrectionLevel.M;
            }
            case Q: {
                return com.google.zxing.qrcode.decoder.ErrorCorrectionLevel.Q;
            }
            case H: {
                return com.google.zxing.qrcode.decoder.ErrorCorrectionLevel.H;
            }
        }
        throw new BarcodeException("Invalid error correction level");
    }

    public ErrorCorrectionLevel getErrorCorrectionLevel() throws OptionException {
        return this.optionContainer.getErrorCorrectionLevelOptionValue("errorCorrectionLevel");
    }

    public void setErrorCorrectionLevel(ErrorCorrectionLevel errorCorrectionLevel) throws OptionException {
        this.optionContainer.setOption("errorCorrectionLevel", errorCorrectionLevel);
    }

    public int getScale() throws OptionException {
        return this.optionContainer.getIntegerOptionValue("scale");
    }

    public void setScale(int scale) throws OptionException {
        this.optionContainer.setOption("scale", scale);
    }

    public void setAutoscale(boolean autoscale) throws OptionException {
        this.optionContainer.setOption("autoscale", autoscale);
    }

    public boolean isAutoscale() throws OptionException {
        return this.optionContainer.getBooleanOptionValue("autoscale");
    }

    public void setPadded(boolean padded) throws OptionException {
        this.optionContainer.setOption("padded", padded);
    }

    public boolean isPadded() throws OptionException {
        return this.optionContainer.getBooleanOptionValue("padded");
    }

    @Override
    public String getDefaultMessage() {
        return "Hello, I'm a QR Code";
    }

    public static enum ErrorCorrectionLevel {
        L,
        M,
        Q,
        H;

    }
}

