/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.barcode.specific;

import at.mrdevelopment.toolkit.ExceptionElement;
import at.mrdevelopment.toolkit.ExecutionStatus;
import at.mrdevelopment.toolkit.barcode.Barcode;
import at.mrdevelopment.toolkit.barcode.BarcodeException;
import at.mrdevelopment.toolkit.barcode.BarcodeImage;
import at.mrdevelopment.toolkit.barcode.BarcodeRenderingResult;
import at.mrdevelopment.toolkit.barcode.BarcodeUtils;
import at.mrdevelopment.toolkit.definition.TemplateElementType;
import at.mrdevelopment.toolkit.definition.TemplateNode;
import at.mrdevelopment.toolkit.image.ImageUtils;
import at.mrdevelopment.toolkit.math.Conversion;
import at.mrdevelopment.toolkit.options.Option;
import at.mrdevelopment.toolkit.options.OptionException;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfiguration;

@TemplateElementType(type=TemplateNode.BARCODE_PDF417)
public class PDF417Code
extends Barcode {
    private static final String B4J_IDENTIFIER = "pdf417";
    private static final int MODULES_PER_COLUMN = 17;
    private static final int ADDITIONAL_COLUMNS = 2;
    private static final int START_STOP_PATTERNS_TOTAL_WIDTH_IN_MW = 35;
    private static final int MIN_COLUMNS_B4J_CONSTRAINT = 1;
    private static final int MAX_COLUMNS_B4J_CONSTRAINT = 30;
    private static final int MIN_ROWS_B4J_CONSTRAINT = 3;
    private static final int MAX_ROWS_B4J_CONSTRAINT = 90;
    public static final double DEFAULT_ROW_HEIGHT_RATIO = 3.0;
    public static final int DEFAULT_COLUMNS = 0;
    public static final int DEFAULT_MIN_COLUMNS = 2;
    public static final int DEFAULT_MAX_COLUMNS = 2;
    public static final int DEFAULT_MIN_ROWS = 3;
    public static final int DEFAULT_MAX_ROWS = 90;
    public static final int DEFAULT_EC_LEVEL = 0;
    public static final double DEFAULT_WIDTH_TO_HEIGHT_RATIO = 3.0;
    public static final boolean DEFAULT_PADDED = false;
    public static final int DEFAULT_QUIET_ZONE_FACTOR = 2;
    public static final int DEFAULT_VERTICAL_QUIET_ZONE_FACTOR = 2;
    public static final boolean DEFAULT_QUIET_ZONE_ENABLED = true;
    public static final int DEFAULT_SCALE = 1;
    private static final int MINIMUM_SCALE = 1;
    public static final boolean DEFAULT_AUTO_MODE = true;

    public PDF417Code() throws OptionException {
        super(PDF417Code.class);
    }

    public PDF417Code(Map<String, Option<?>> options) throws OptionException {
        super(options);
    }

    @Override
    public BarcodeRenderingResult render(String message, int maxWidthPx, int maxHeightPx) {
        BarcodeRenderingResult result;
        block25: {
            ExecutionStatus status = new ExecutionStatus();
            result = new BarcodeRenderingResult(this.createEmptyImage(maxWidthPx, maxHeightPx), status);
            if (message == null) {
                if (this.verbose) {
                    status.addElement(new ExceptionElement(new BarcodeException("Message to convert was null")));
                }
                result.setSuccessful(false);
                return result;
            }
            try {
                if (this.getScale() < 1) {
                    this.setScale(1.0);
                    result.setSuccessful(false);
                    if (this.verbose) {
                        ExceptionElement exceptionElement = new ExceptionElement(new BarcodeException("Scale is set lower than 1"));
                        status.addElement(exceptionElement);
                    }
                }
                double moduleWidth = Conversion.getDisplaySizeInMM(152, this.getScale());
                double topTerm = (double)maxWidthPx - this.calcQuietZone() - 35.0 * (double)this.getScale();
                double botTerm = 17.0 * (double)this.getScale();
                double maxColsExact = topTerm / botTerm - 2.0;
                int maxCols = (int)Math.floor(maxColsExact);
                int maxRows = (int)Math.floor(((double)maxHeightPx - this.calcVerticalQuietZone()) / (this.getRowHeightRatio() * (double)this.getScale()));
                maxCols = Math.min(maxCols, 30);
                maxCols = Math.max(maxCols, 1);
                maxRows = Math.min(maxRows, 90);
                maxRows = Math.max(maxRows, 3);
                BarcodeImage barcodeImage = null;
                BufferedImage image = null;
                barcodeImage = this.isAutoMode() ? BarcodeUtils.getBarcode4JCode(message, this.createBarcodeConfiguration(moduleWidth, this.getQuietZoneFactor(), this.getVerticalQuietZoneFactor(), this.isQuietZoneEnabled(), 3.0, 0, 1, maxCols, 3, maxRows, this.getEcLevel(), 3.0)) : BarcodeUtils.getBarcode4JCode(message, this.createBarcodeConfiguration(moduleWidth, this.getQuietZoneFactor(), this.getVerticalQuietZoneFactor(), this.isQuietZoneEnabled(), this.getRowHeightRatio(), this.getColumns(), this.getMinColumns(), this.getMaxColumns(), this.getMinRows(), this.getMaxRows(), this.getEcLevel(), this.getWidthToHeightRatio()));
                boolean clip = false;
                image = barcodeImage.getBarcodeImage();
                if (barcodeImage.getBarcodeWidth() > maxWidthPx) {
                    if (this.verbose) {
                        status.addElement(new ExceptionElement(new BarcodeException("Barcode is wider than allowed")));
                    }
                    clip = true;
                }
                if (barcodeImage.getBarcodeHeight() > maxHeightPx) {
                    if (this.verbose) {
                        status.addElement(new ExceptionElement(new BarcodeException("Barcode is higher than allowed")));
                    }
                    clip = true;
                }
                if (clip) {
                    result.setSuccessful(false);
                    image = ImageUtils.clip(image, new Rectangle(Math.min(barcodeImage.getBarcodeWidth(), maxWidthPx), Math.min(barcodeImage.getBarcodeHeight(), maxHeightPx)), 2);
                } else if (this.isPadded()) {
                    BufferedImage wrapperImage = new BufferedImage(maxWidthPx, maxHeightPx, 12);
                    ImageUtils.fill(wrapperImage, Color.white);
                    ImageUtils.overlay(wrapperImage, image);
                    result.setImage(wrapperImage);
                    return result;
                }
                result.setImage(image);
                return result;
            }
            catch (ConfigurationException e) {
                result.setSuccessful(false);
                if (this.verbose) {
                    status.addElement(new ExceptionElement(new BarcodeException(e.getMessage(), e.getCause())));
                }
            }
            catch (org.krysalis.barcode4j.BarcodeException e) {
                result.setSuccessful(false);
                if (this.verbose) {
                    status.addElement(new ExceptionElement(new BarcodeException(e.getMessage(), e.getCause())));
                }
            }
            catch (IOException e) {
                result.setSuccessful(false);
                if (this.verbose) {
                    status.addElement(new ExceptionElement(new BarcodeException(e.getMessage(), e.getCause())));
                }
            }
            catch (OptionException e) {
                result.setSuccessful(false);
                if (this.verbose) {
                    status.addElement(new ExceptionElement(new BarcodeException(e.getMessage(), e.getCause())));
                }
            }
            catch (IllegalArgumentException e) {
                result.setSuccessful(false);
                if (this.verbose) {
                    status.addElement(new ExceptionElement(new BarcodeException(e.getMessage(), e.getCause())));
                }
            }
            catch (BarcodeException e) {
                result.setSuccessful(false);
                if (this.verbose) {
                    status.addElement(new ExceptionElement(e));
                }
            }
            catch (Exception e) {
                result.setSuccessful(false);
                if (!this.verbose) break block25;
                status.addElement(new ExceptionElement(e));
            }
        }
        return result;
    }

    private Configuration createBarcodeConfiguration(double moduleWidth, int quietZoneFactor, int verticalQuietZoneFactor, boolean quietZoneEnabled, double rowHeightRatio, int columns, int minColumns, int maxColumns, int minRows, int maxRows, int ecLevel, double widthToHeightRatio) throws BarcodeException {
        DefaultConfiguration barcodeConf = new DefaultConfiguration("barcode");
        DefaultConfiguration tagTypeConf = new DefaultConfiguration(B4J_IDENTIFIER);
        tagTypeConf.addChild(BarcodeUtils.getBarcode4JConfigurationElement("module-width", moduleWidth + "mm", new String[0]));
        tagTypeConf.addChild(BarcodeUtils.getBarcode4JConfigurationElement("quiet-zone", "" + quietZoneFactor + "mw", "enabled", quietZoneEnabled ? "true" : "false"));
        tagTypeConf.addChild(BarcodeUtils.getBarcode4JConfigurationElement("quiet-zone", "" + verticalQuietZoneFactor + "mw", new String[0]));
        tagTypeConf.addChild(BarcodeUtils.getBarcode4JConfigurationElement("row-height", "" + rowHeightRatio + "mw", new String[0]));
        if (columns > 0) {
            tagTypeConf.addChild(BarcodeUtils.getBarcode4JConfigurationElement("columns", "" + columns, new String[0]));
        }
        tagTypeConf.addChild(BarcodeUtils.getBarcode4JConfigurationElement("min-columns", "" + minColumns, new String[0]));
        tagTypeConf.addChild(BarcodeUtils.getBarcode4JConfigurationElement("max-columns", "" + maxColumns, new String[0]));
        tagTypeConf.addChild(BarcodeUtils.getBarcode4JConfigurationElement("min-rows", "" + minRows, new String[0]));
        tagTypeConf.addChild(BarcodeUtils.getBarcode4JConfigurationElement("max-rows", "" + maxRows, new String[0]));
        tagTypeConf.addChild(BarcodeUtils.getBarcode4JConfigurationElement("ec-level", "" + ecLevel, new String[0]));
        tagTypeConf.addChild(BarcodeUtils.getBarcode4JConfigurationElement("width-to-height-ratio", "" + widthToHeightRatio, new String[0]));
        barcodeConf.addChild((Configuration)tagTypeConf);
        return barcodeConf;
    }

    private double calcQuietZone() throws OptionException {
        if (this.isQuietZoneEnabled()) {
            return (double)(this.getQuietZoneFactor() * this.getScale()) * 2.0;
        }
        return 0.0;
    }

    private double calcVerticalQuietZone() throws OptionException {
        if (this.isQuietZoneEnabled()) {
            return (double)(this.getVerticalQuietZoneFactor() * this.getScale()) * 2.0;
        }
        return 0.0;
    }

    public double getRowHeightRatio() throws OptionException {
        return this.optionContainer.getDoubleOptionValue("rowHeightRatio");
    }

    public void setRowHeightRatio(double rowHeightRatio) throws OptionException {
        this.optionContainer.setOption("rowHeightRatio", rowHeightRatio);
    }

    public int getColumns() throws OptionException {
        return this.optionContainer.getIntegerOptionValue("columns");
    }

    public void setColumns(int columns) throws OptionException {
        this.optionContainer.setOption("columns", columns);
    }

    public int getMinColumns() throws OptionException {
        return this.optionContainer.getIntegerOptionValue("minColumns");
    }

    public void setMinColumns(int minColumns) throws OptionException {
        this.optionContainer.setOption("minColumns", minColumns);
    }

    public int getMaxColumns() throws OptionException {
        return this.optionContainer.getIntegerOptionValue("maxColumns");
    }

    public void setMaxColumns(int maxColumns) throws OptionException {
        this.optionContainer.setOption("maxColumns", maxColumns);
    }

    public int getMinRows() throws OptionException {
        return this.optionContainer.getIntegerOptionValue("minRows");
    }

    public void setMinRows(int minRows) throws OptionException {
        this.optionContainer.setOption("minRows", minRows);
    }

    public int getMaxRows() throws OptionException {
        return this.optionContainer.getIntegerOptionValue("maxRows");
    }

    public void setMaxRows(int maxRows) throws OptionException {
        this.optionContainer.setOption("maxRows", maxRows);
    }

    public int getEcLevel() throws OptionException {
        return this.optionContainer.getIntegerOptionValue("ecLevel");
    }

    public void setEcLevel(int ecLevel) throws OptionException {
        this.optionContainer.setOption("ecLevel", ecLevel);
    }

    public double getWidthToHeightRatio() throws OptionException {
        return this.optionContainer.getDoubleOptionValue("widthToHeightRatio");
    }

    public void setWidthToHeightRatio(double widthToHeightRatio) throws OptionException {
        this.optionContainer.setOption("widthToHeightRatio", widthToHeightRatio);
    }

    public int getQuietZoneFactor() throws OptionException {
        return this.optionContainer.getIntegerOptionValue("quietZoneFactor");
    }

    public void setQuietZoneFactor(int quietZoneFactor) throws OptionException {
        this.optionContainer.setOption("quietZoneFactor", quietZoneFactor);
    }

    public int getVerticalQuietZoneFactor() throws OptionException {
        return this.optionContainer.getIntegerOptionValue("verticalQuietZoneFactor");
    }

    public void setVerticalQuietZoneFactor(int verticalQuietZoneFactor) throws OptionException {
        this.optionContainer.setOption("verticalQuietZoneFactor", verticalQuietZoneFactor);
    }

    public boolean isQuietZoneEnabled() throws OptionException {
        return this.optionContainer.getBooleanOptionValue("quietZoneEnabled");
    }

    public void setQuietZoneEnabled(boolean quietZoneEnabled) throws OptionException {
        this.optionContainer.setOption("quietZoneEnabled", quietZoneEnabled);
    }

    public boolean isAutoMode() throws OptionException {
        return this.optionContainer.getBooleanOptionValue("autoMode");
    }

    public void setAutoMode(boolean autoMode) throws OptionException {
        this.optionContainer.setOption("autoMode", autoMode);
    }

    public int getScale() throws OptionException {
        return this.optionContainer.getIntegerOptionValue("scale");
    }

    public void setScale(double scale) throws OptionException {
        this.optionContainer.setOption("scale", scale);
    }

    public void setPadded(boolean padded) throws OptionException {
        this.optionContainer.setOption("padded", padded);
    }

    public boolean isPadded() throws OptionException {
        return this.optionContainer.getBooleanOptionValue("padded");
    }

    @Override
    public String getDefaultMessage() {
        return "123000000123";
    }
}

