/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.barcode.specific;

import at.mrdevelopment.toolkit.barcode.Barcode1D;
import at.mrdevelopment.toolkit.barcode.BarcodeException;
import at.mrdevelopment.toolkit.barcode.BarcodeUtils;
import at.mrdevelopment.toolkit.definition.TemplateElementType;
import at.mrdevelopment.toolkit.definition.TemplateNode;
import at.mrdevelopment.toolkit.options.Option;
import at.mrdevelopment.toolkit.options.OptionException;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.DefaultConfiguration;

@TemplateElementType(type=TemplateNode.BARCODE_EAN128)
public class EAN128Code
extends Barcode1D {
    private static final String B4J_IDENTIFIER = "ean-128";
    public static final String DEFAULT_TEMPLATE = "";
    public static final boolean DEFAULT_OMIT_BRACKETS = false;

    public EAN128Code() throws OptionException {
        super((Class<? extends Barcode1D>)EAN128Code.class);
    }

    public EAN128Code(Map<String, Option<?>> options) throws OptionException {
        super(options);
    }

    @Override
    protected Configuration createBarcodeConfiguration(double moduleWidth, double height) throws BarcodeException, OptionException {
        DefaultConfiguration barcodeConf = new DefaultConfiguration("barcode");
        DefaultConfiguration tagTypeConf = new DefaultConfiguration(B4J_IDENTIFIER);
        tagTypeConf.addChild(BarcodeUtils.getBarcode4JConfigurationElement("module-width", moduleWidth + "mm", new String[0]));
        tagTypeConf.addChild(BarcodeUtils.getBarcode4JConfigurationElement("height", height + "mm", new String[0]));
        String template = this.getTemplate();
        if (template != null && !template.isEmpty()) {
            tagTypeConf.addChild(BarcodeUtils.getBarcode4JConfigurationElement("template", template, new String[0]));
        }
        tagTypeConf.addChild(BarcodeUtils.getBarcode4JConfigurationElement("omit-brackets", this.isOmitBrackets() ? "true" : "false", new String[0]));
        tagTypeConf.addChild(BarcodeUtils.getBarcode4JConfigurationElement("quiet-zone", DEFAULT_TEMPLATE + this.getQuietZoneFactor() + "mw", "enabled", this.isQuietZoneEnabled() ? "true" : "false"));
        tagTypeConf.addChild((Configuration)BarcodeUtils.createBasicHumanReadableConfiguration(this.getFontSizePt(), this.getFontName(), this.isHumanReadableEnabled(), this.getHumanReadablePlacement()));
        barcodeConf.addChild((Configuration)tagTypeConf);
        return barcodeConf;
    }

    public String getTemplate() throws OptionException {
        return this.optionContainer.getStringOptionValue("template");
    }

    public void setTemplate(String template) throws OptionException {
        this.optionContainer.setOption("template", template);
    }

    public boolean isOmitBrackets() throws OptionException {
        return this.optionContainer.getBooleanOptionValue("omitBrackets");
    }

    public void setOmitBrackets(boolean omitBrackets) throws OptionException {
        this.optionContainer.setOption("omitBrackets", omitBrackets);
    }

    @Override
    public String getDefaultMessage() {
        return "12300002";
    }
}

