/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.barcode.specific;

import at.mrdevelopment.toolkit.ExceptionElement;
import at.mrdevelopment.toolkit.ExecutionStatus;
import at.mrdevelopment.toolkit.barcode.Barcode;
import at.mrdevelopment.toolkit.barcode.BarcodeException;
import at.mrdevelopment.toolkit.barcode.BarcodeImage;
import at.mrdevelopment.toolkit.barcode.BarcodeRenderingResult;
import at.mrdevelopment.toolkit.barcode.BarcodeUtils;
import at.mrdevelopment.toolkit.definition.TemplateElementType;
import at.mrdevelopment.toolkit.definition.TemplateNode;
import at.mrdevelopment.toolkit.image.ImageUtils;
import at.mrdevelopment.toolkit.math.Conversion;
import at.mrdevelopment.toolkit.options.Option;
import at.mrdevelopment.toolkit.options.OptionException;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfiguration;
import org.krysalis.barcode4j.BarcodeDimension;

@TemplateElementType(type=TemplateNode.BARCODE_DATAMATRIX)
public class DataMatrixCode
extends Barcode {
    private static final String B4J_IDENTIFIER = "datamatrix";
    public static final Shape DEFAULT_SHAPE = Shape.NONE;
    public static final int DEFAULT_MIN_SYMBOL_SIZE_WIDTH = 1;
    public static final int DEFAULT_MIN_SYMBOL_SIZE_HEIGHT = 1;
    public static final int DEFAULT_MAX_SYMBOL_SIZE_WIDTH = 0;
    public static final int DEFAULT_MAX_SYMBOL_SIZE_HEIGHT = 1;
    public static final boolean DEFAULT_PADDED = false;
    public static final int DEFAULT_QUIET_ZONE_FACTOR = 1;
    public static final boolean DEFAULT_QUIET_ZONE_ENABLED = true;
    public static final int DEFAULT_SCALE = 1;
    private static final int MINIMUM_SCALE = 1;
    public static final boolean DEFAULT_AUTOSCALE = false;
    private static final String DIMENSION_DELIMITER = "x";

    public DataMatrixCode() throws OptionException {
        super(DataMatrixCode.class);
    }

    public DataMatrixCode(Map<String, Option<?>> options) throws OptionException {
        super(options);
    }

    @Override
    public BarcodeRenderingResult render(String message, int maxWidthPx, int maxHeightPx) {
        BarcodeRenderingResult result;
        block26: {
            ExecutionStatus status = new ExecutionStatus();
            result = new BarcodeRenderingResult(this.createEmptyImage(maxWidthPx, maxHeightPx), status);
            if (message == null) {
                if (this.verbose) {
                    status.addElement(new ExceptionElement(new BarcodeException("Message to convert was null")));
                }
                result.setSuccessful(false);
                return result;
            }
            try {
                if (!this.isAutoscale() && this.getScale() < 1) {
                    this.setScale(1);
                    result.setSuccessful(false);
                    if (this.verbose) {
                        ExceptionElement exceptionElement = new ExceptionElement(new BarcodeException("Scale is set lower than 1"));
                        status.addElement(exceptionElement);
                    }
                }
                double moduleWidth = Conversion.getDisplaySizeInMM(152, this.getScale());
                BarcodeImage barcodeImage = null;
                BufferedImage image = null;
                if (this.isAutoscale()) {
                    double maxSize = Conversion.getDisplaySizeInMM(152, Math.min(maxWidthPx, maxHeightPx));
                    BarcodeDimension initialDimension = BarcodeUtils.getBarcode4JDimension(message, this.createBarcodeConfiguration(moduleWidth, maxWidthPx, maxHeightPx));
                    double moduleWidthStretched = BarcodeUtils.calcModuleWidth(maxSize, this.getQuietZoneFactor(), initialDimension, moduleWidth);
                    this.setScale((int)Math.max(1.0, Math.floor(BarcodeUtils.calcPixelsPerModule(moduleWidthStretched))));
                    moduleWidth = Conversion.getDisplaySizeInMM(152, this.getScale());
                }
                barcodeImage = BarcodeUtils.getBarcode4JCode(message, this.createBarcodeConfiguration(moduleWidth, maxWidthPx, maxHeightPx));
                image = barcodeImage.getBarcodeImage();
                boolean clip = false;
                if (barcodeImage.getBarcodeWidth() > maxWidthPx) {
                    if (this.verbose) {
                        status.addElement(new ExceptionElement(new BarcodeException("Barcode is wider than allowed")));
                    }
                    clip = true;
                }
                if (barcodeImage.getBarcodeHeight() > maxHeightPx) {
                    if (this.verbose) {
                        status.addElement(new ExceptionElement(new BarcodeException("Barcode is higher than allowed")));
                    }
                    clip = true;
                }
                if (clip) {
                    result.setSuccessful(false);
                    image = ImageUtils.clip(image, new Rectangle(Math.min(barcodeImage.getBarcodeWidth(), maxWidthPx), Math.min(barcodeImage.getBarcodeHeight(), maxHeightPx)), 2);
                } else if (this.isPadded()) {
                    BufferedImage wrapperImage = new BufferedImage(maxWidthPx, maxHeightPx, 12);
                    ImageUtils.fill(wrapperImage, Color.white);
                    ImageUtils.overlay(wrapperImage, image);
                    result.setImage(wrapperImage);
                    return result;
                }
                result.setImage(image);
                return result;
            }
            catch (ConfigurationException e) {
                result.setSuccessful(false);
                if (this.verbose) {
                    status.addElement(new ExceptionElement(new BarcodeException(e.getMessage(), e.getCause())));
                }
            }
            catch (org.krysalis.barcode4j.BarcodeException e) {
                result.setSuccessful(false);
                if (this.verbose) {
                    status.addElement(new ExceptionElement(new BarcodeException(e.getMessage(), e.getCause())));
                }
            }
            catch (IOException e) {
                result.setSuccessful(false);
                if (this.verbose) {
                    status.addElement(new ExceptionElement(new BarcodeException(e.getMessage(), e.getCause())));
                }
            }
            catch (OptionException e) {
                result.setSuccessful(false);
                if (this.verbose) {
                    status.addElement(new ExceptionElement(new BarcodeException(e.getMessage(), e.getCause())));
                }
            }
            catch (IllegalArgumentException e) {
                result.setSuccessful(false);
                if (this.verbose) {
                    status.addElement(new ExceptionElement(new BarcodeException(e.getMessage(), e.getCause())));
                }
            }
            catch (BarcodeException e) {
                result.setSuccessful(false);
                if (this.verbose) {
                    status.addElement(new ExceptionElement(e));
                }
            }
            catch (Exception e) {
                result.setSuccessful(false);
                if (!this.verbose) break block26;
                status.addElement(new ExceptionElement(e));
            }
        }
        return result;
    }

    protected Configuration createBarcodeConfiguration(double moduleWidth, int maxWidthPx, int maxHeightPx) throws BarcodeException, OptionException {
        DefaultConfiguration barcodeConf = new DefaultConfiguration("barcode");
        DefaultConfiguration tagTypeConf = new DefaultConfiguration(B4J_IDENTIFIER);
        tagTypeConf.addChild(BarcodeUtils.getBarcode4JConfigurationElement("module-width", moduleWidth + "mm", new String[0]));
        tagTypeConf.addChild(BarcodeUtils.getBarcode4JConfigurationElement("shape", BarcodeUtils.shapeToB4JString(this.getShape()), new String[0]));
        int minSymbolSizeWidth = this.getMinSymbolSizeWidth();
        int minSymbolSizeHeight = this.getMinSymbolSizeHeight();
        if (this.isZeroDimension(minSymbolSizeWidth, minSymbolSizeHeight)) {
            tagTypeConf.addChild(BarcodeUtils.getBarcode4JConfigurationElement("min-symbol-size", "1x1", new String[0]));
        } else {
            tagTypeConf.addChild(BarcodeUtils.getBarcode4JConfigurationElement("min-symbol-size", minSymbolSizeWidth + DIMENSION_DELIMITER + minSymbolSizeHeight, new String[0]));
        }
        int maxWidthModules = (int)Math.round((double)maxWidthPx / (double)this.getScale());
        int maxHeightModules = (int)Math.round((double)maxHeightPx / (double)this.getScale());
        int maxSymbolSizeWidth = this.getMaxSymbolSizeWidth();
        int maxSymbolSizeHeight = this.getMaxSymbolSizeHeight();
        if (this.isZeroDimension(maxSymbolSizeWidth, maxSymbolSizeHeight)) {
            tagTypeConf.addChild(BarcodeUtils.getBarcode4JConfigurationElement("max-symbol-size", maxWidthModules + DIMENSION_DELIMITER + maxHeightModules, new String[0]));
        } else {
            tagTypeConf.addChild(BarcodeUtils.getBarcode4JConfigurationElement("max-symbol-size", maxSymbolSizeWidth + DIMENSION_DELIMITER + maxSymbolSizeHeight, new String[0]));
        }
        tagTypeConf.addChild(BarcodeUtils.getBarcode4JConfigurationElement("quiet-zone", "" + this.getQuietZoneFactor() + "mw", "enabled", this.isQuietZoneEnabled() ? "true" : "false"));
        barcodeConf.addChild((Configuration)tagTypeConf);
        return barcodeConf;
    }

    private boolean isZeroDimension(int width, int height) {
        return width <= 0 || height <= 0;
    }

    public boolean isQuietZoneEnabled() throws OptionException {
        return this.optionContainer.getBooleanOptionValue("quietZoneEnabled");
    }

    public void setQuietZoneEnabled(boolean quietZoneEnabled) throws OptionException {
        this.optionContainer.setOption("quietZoneEnabled", quietZoneEnabled);
    }

    public int getQuietZoneFactor() throws OptionException {
        return this.optionContainer.getIntegerOptionValue("quietZoneFactor");
    }

    public void setQuietZoneFactor(int quietZoneFactor) throws OptionException {
        this.optionContainer.setOption("quietZoneFactor", quietZoneFactor);
    }

    public int getScale() throws OptionException {
        return this.optionContainer.getIntegerOptionValue("scale");
    }

    public void setScale(int scale) throws OptionException {
        this.optionContainer.setOption("scale", scale);
    }

    public void setPadded(boolean padded) throws OptionException {
        this.optionContainer.setOption("padded", padded);
    }

    public boolean isPadded() throws OptionException {
        return this.optionContainer.getBooleanOptionValue("padded");
    }

    public void setAutoscale(boolean autoscale) throws OptionException {
        this.optionContainer.setOption("autoscale", autoscale);
    }

    public boolean isAutoscale() throws OptionException {
        return this.optionContainer.getBooleanOptionValue("autoscale");
    }

    public Shape getShape() throws OptionException {
        return this.optionContainer.getShapeOptionValue("shape");
    }

    public void setShape(Shape shape) throws OptionException {
        this.optionContainer.setOption("shape", shape);
    }

    public int getMinSymbolSizeWidth() throws OptionException {
        return this.optionContainer.getIntegerOptionValue("minSymbolSizeWidth");
    }

    public int getMinSymbolSizeHeight() throws OptionException {
        return this.optionContainer.getIntegerOptionValue("minSymbolSizeHeight");
    }

    public void setMinSymbolSize(int width, int height) throws OptionException {
        this.optionContainer.setOption("minSymbolSizeWidth", width);
        this.optionContainer.setOption("minSymbolSizeHeight", height);
    }

    public int getMaxSymbolSizeWidth() throws OptionException {
        return this.optionContainer.getIntegerOptionValue("maxSymbolSizeWidth");
    }

    public int getMaxSymbolSizeHeight() throws OptionException {
        return this.optionContainer.getIntegerOptionValue("maxSymbolSizeHeight");
    }

    public void setMaxSymbolSize(int width, int height) throws OptionException {
        this.optionContainer.setOption("maxSymbolSizeWidth", width);
        this.optionContainer.setOption("maxSymbolSizeHeight", height);
    }

    @Override
    public String getDefaultMessage() {
        return "1230000234221";
    }

    public static enum Shape {
        NONE,
        RECTANGLE,
        SQUARE;

    }
}

