/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.barcode.specific;

import at.mrdevelopment.toolkit.barcode.Barcode1D;
import at.mrdevelopment.toolkit.barcode.BarcodeException;
import at.mrdevelopment.toolkit.barcode.BarcodeUtils;
import at.mrdevelopment.toolkit.definition.TemplateElementType;
import at.mrdevelopment.toolkit.definition.TemplateNode;
import at.mrdevelopment.toolkit.options.Option;
import at.mrdevelopment.toolkit.options.OptionException;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.DefaultConfiguration;

@TemplateElementType(type=TemplateNode.BARCODE_CODE39)
public class Code39Code
extends Barcode1D {
    private static final String B4J_IDENTIFIER = "code39";
    public static final boolean DEFAULT_DISPLAY_START_STOP = false;
    public static final boolean DEFAULT_DISPLAY_CHECKSUM = false;
    public static final Barcode1D.ChecksumMode DEFAULT_CHECKSUM_MODE = Barcode1D.ChecksumMode.IGNORE;
    public static final int DEFAULT_INTERCHAR_GAP_WIDTH = 1;
    public static final boolean DEFAULT_EXTENDED_CHARSET = false;

    public Code39Code() throws OptionException {
        super((Class<? extends Barcode1D>)Code39Code.class);
    }

    public Code39Code(Map<String, Option<?>> options) throws OptionException {
        super(options);
    }

    @Override
    protected Configuration createBarcodeConfiguration(double moduleWidth, double height) throws BarcodeException, OptionException {
        DefaultConfiguration barcodeConf = new DefaultConfiguration("barcode");
        DefaultConfiguration tagTypeConf = new DefaultConfiguration(B4J_IDENTIFIER);
        tagTypeConf.addChild(BarcodeUtils.getBarcode4JConfigurationElement("module-width", moduleWidth + "mm", new String[0]));
        tagTypeConf.addChild(BarcodeUtils.getBarcode4JConfigurationElement("height", height + "mm", new String[0]));
        tagTypeConf.addChild(BarcodeUtils.getBarcode4JConfigurationElement("checksum", BarcodeUtils.checksumModeToB4JString(this.getChecksumMode()), new String[0]));
        tagTypeConf.addChild(BarcodeUtils.getBarcode4JConfigurationElement("interchar-gap-width", this.getIntercharGapWidth() + "mw", new String[0]));
        tagTypeConf.addChild(BarcodeUtils.getBarcode4JConfigurationElement("extended-charset", this.isExtendedCharset() ? "true" : "false", new String[0]));
        tagTypeConf.addChild(BarcodeUtils.getBarcode4JConfigurationElement("quiet-zone", "" + this.getQuietZoneFactor() + "mw", "enabled", this.isQuietZoneEnabled() ? "true" : "false"));
        DefaultConfiguration humanReadableConfig = BarcodeUtils.createBasicHumanReadableConfiguration(this.getFontSizePt(), this.getFontName(), this.isHumanReadableEnabled(), this.getHumanReadablePlacement());
        humanReadableConfig.addChild(BarcodeUtils.getBarcode4JConfigurationElement("display-start-stop", this.isDisplayStartStop() ? "true" : "false", new String[0]));
        humanReadableConfig.addChild(BarcodeUtils.getBarcode4JConfigurationElement("display-checksum", this.isDisplayChecksum() ? "true" : "false", new String[0]));
        tagTypeConf.addChild((Configuration)humanReadableConfig);
        barcodeConf.addChild((Configuration)tagTypeConf);
        return barcodeConf;
    }

    public boolean isDisplayStartStop() throws OptionException {
        return this.optionContainer.getBooleanOptionValue("displayStartStop");
    }

    public void setDisplayStartStop(boolean displayStartStop) throws OptionException {
        this.optionContainer.setOption("displayStartStop", displayStartStop);
    }

    public boolean isDisplayChecksum() throws OptionException {
        return this.optionContainer.getBooleanOptionValue("displayChecksum");
    }

    public void setDisplayChecksum(boolean displayChecksum) throws OptionException {
        this.optionContainer.setOption("displayChecksum", displayChecksum);
    }

    public Barcode1D.ChecksumMode getChecksumMode() throws OptionException {
        return this.optionContainer.getChecksumModeOptionValue("checksumMode");
    }

    public void setChecksumMode(Barcode1D.ChecksumMode checksumMode) throws OptionException {
        this.optionContainer.setOption("checksumMode", checksumMode);
    }

    public int getIntercharGapWidth() throws OptionException {
        return this.optionContainer.getIntegerOptionValue("intercharGapWidth");
    }

    public void setIntercharGapWidth(int intercharGapWidth) throws OptionException {
        this.optionContainer.setOption("intercharGapWidth", intercharGapWidth);
    }

    public boolean isExtendedCharset() throws OptionException {
        return this.optionContainer.getBooleanOptionValue("extendedCharset");
    }

    public void setExtendedCharset(boolean extendedCharset) throws OptionException {
        this.optionContainer.setOption("extendedCharset", extendedCharset);
    }

    @Override
    public String getDefaultMessage() {
        return "123000000123";
    }
}

