/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.barcode.specific;

import at.mrdevelopment.toolkit.barcode.Barcode1D;
import at.mrdevelopment.toolkit.barcode.BarcodeException;
import at.mrdevelopment.toolkit.barcode.BarcodeUtils;
import at.mrdevelopment.toolkit.definition.TemplateElementType;
import at.mrdevelopment.toolkit.definition.TemplateNode;
import at.mrdevelopment.toolkit.options.Option;
import at.mrdevelopment.toolkit.options.OptionException;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.DefaultConfiguration;

@TemplateElementType(type=TemplateNode.BARCODE_CODE128)
public class Code128Code
extends Barcode1D {
    private static final String B4J_IDENTIFIER = "code128";
    public static final String DEFAULT_CODESETS = "ABC";

    public Code128Code() throws OptionException {
        super((Class<? extends Barcode1D>)Code128Code.class);
    }

    public Code128Code(Map<String, Option<?>> options) throws OptionException {
        super(options);
    }

    @Override
    protected Configuration createBarcodeConfiguration(double moduleWidth, double height) throws BarcodeException, OptionException {
        DefaultConfiguration barcodeConf = new DefaultConfiguration("barcode");
        DefaultConfiguration tagTypeConf = new DefaultConfiguration(B4J_IDENTIFIER);
        tagTypeConf.addChild(BarcodeUtils.getBarcode4JConfigurationElement("module-width", moduleWidth + "mm", new String[0]));
        tagTypeConf.addChild(BarcodeUtils.getBarcode4JConfigurationElement("height", height + "mm", new String[0]));
        tagTypeConf.addChild(BarcodeUtils.getBarcode4JConfigurationElement("codesets", this.getCodesets(), new String[0]));
        tagTypeConf.addChild(BarcodeUtils.getBarcode4JConfigurationElement("quiet-zone", "" + this.getQuietZoneFactor() + "mw", "enabled", this.isQuietZoneEnabled() ? "true" : "false"));
        tagTypeConf.addChild((Configuration)BarcodeUtils.createBasicHumanReadableConfiguration(this.getFontSizePt(), this.getFontName(), this.isHumanReadableEnabled(), this.getHumanReadablePlacement()));
        barcodeConf.addChild((Configuration)tagTypeConf);
        return barcodeConf;
    }

    public String getCodesets() throws OptionException {
        return this.optionContainer.getStringOptionValue("codesets");
    }

    public void setCodesets(String codesets) throws OptionException {
        this.optionContainer.setOption("codesets", codesets);
    }

    @Override
    public String getDefaultMessage() {
        return "123000000123";
    }
}

