/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.barcode;

import at.mrdevelopment.toolkit.image.ImageUtils;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import org.krysalis.barcode4j.BarcodeDimension;

public class BarcodeImage {
    private final BufferedImage image;
    private final int width;
    private final int height;

    public BarcodeImage(BufferedImage image, BarcodeDimension dimension, int dpi) {
        this.image = image;
        this.width = (int)Math.round(dimension.getWidthPlusQuiet() / 10.0 * (double)dpi / 2.54);
        this.height = (int)Math.round(dimension.getHeightPlusQuiet() / 10.0 * (double)dpi / 2.54);
    }

    public BufferedImage getCompleteImage() {
        return this.image;
    }

    public BufferedImage getBarcodeImage() {
        return ImageUtils.clip(this.image, new Rectangle(this.width, this.height));
    }

    public int getBarcodeWidth() {
        return this.width;
    }

    public int getBarcodeHeight() {
        return this.height;
    }
}

