/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.barcode;

import at.mrdevelopment.toolkit.ExceptionElement;
import at.mrdevelopment.toolkit.ExecutionStatus;
import at.mrdevelopment.toolkit.barcode.Barcode;
import at.mrdevelopment.toolkit.barcode.BarcodeException;
import at.mrdevelopment.toolkit.barcode.BarcodeImage;
import at.mrdevelopment.toolkit.barcode.BarcodeRenderingResult;
import at.mrdevelopment.toolkit.barcode.BarcodeUtils;
import at.mrdevelopment.toolkit.image.ImageUtils;
import at.mrdevelopment.toolkit.math.Conversion;
import at.mrdevelopment.toolkit.options.Option;
import at.mrdevelopment.toolkit.options.OptionException;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.krysalis.barcode4j.BarcodeDimension;

public abstract class Barcode1D
extends Barcode {
    public static final int DEFAULT_FONT_SIZE_PT = 6;
    public static final String DEFAULT_FONT_NAME = "Helvetica";
    public static final HumanReadablePlacement DEFAULT_HUMAN_READABLE_PLACEMENT = HumanReadablePlacement.BOTTOM;
    public static final boolean DEFAULT_HUMAN_READABLE_ENABLED = true;
    public static final int DEFAULT_QUIET_ZONE_FACTOR = 10;
    public static final boolean DEFAULT_QUIET_ZONE_ENABLED = false;
    public static final int DEFAULT_SCALE = 1;
    public static final boolean DEFAULT_AUTOSCALE = false;
    public static final int MINIMUM_SCALE = 1;

    public Barcode1D(Class<? extends Barcode1D> barcodeClass) throws OptionException {
        super(barcodeClass);
    }

    public Barcode1D(Map<String, Option<?>> options) throws OptionException {
        super(options);
    }

    @Override
    public BarcodeRenderingResult render(String message, int maxWidthPx, int maxHeightPx) {
        BarcodeRenderingResult result;
        block24: {
            ExecutionStatus status = new ExecutionStatus();
            result = new BarcodeRenderingResult(this.createEmptyImage(maxWidthPx, maxHeightPx), status);
            if (message == null) {
                if (this.verbose) {
                    status.addElement(new ExceptionElement(new BarcodeException("Message to convert was null")));
                }
                result.setSuccessful(false);
                return result;
            }
            try {
                if (!this.isAutoscale() && this.getScale() < 1) {
                    this.setScale(1);
                    result.setSuccessful(false);
                    if (this.verbose) {
                        ExceptionElement exceptionElement = new ExceptionElement(new BarcodeException("Scale is set lower than 1"));
                        status.addElement(exceptionElement);
                    }
                }
                double maxWidth = Conversion.getDisplaySizeInMM(152, maxWidthPx);
                double maxHeight = Conversion.getDisplaySizeInMM(152, maxHeightPx);
                double moduleWidth = Conversion.getDisplaySizeInMM(152, this.getScale());
                BarcodeDimension initialDimension = BarcodeUtils.getBarcode4JDimension(message, this.createBarcodeConfiguration(moduleWidth, maxHeight));
                double height = BarcodeUtils.calcHeight(maxHeight, initialDimension);
                if (this.isAutoscale()) {
                    double moduleWidthStretched = BarcodeUtils.calcModuleWidth(maxWidth, this.getQuietZoneFactor(), initialDimension, moduleWidth);
                    this.setScale((int)Math.max(1.0, Math.floor(BarcodeUtils.calcPixelsPerModule(moduleWidthStretched))));
                    moduleWidth = Conversion.getDisplaySizeInMM(152, this.getScale());
                }
                BarcodeImage barcodeImage = BarcodeUtils.getBarcode4JCode(message, this.createBarcodeConfiguration(moduleWidth, height));
                BufferedImage image = barcodeImage.getBarcodeImage();
                boolean clip = false;
                if (barcodeImage.getBarcodeWidth() > maxWidthPx) {
                    if (this.verbose) {
                        status.addElement(new ExceptionElement(new BarcodeException("Barcode is wider than allowed")));
                    }
                    clip = true;
                }
                if (barcodeImage.getBarcodeHeight() > maxHeightPx) {
                    if (this.verbose) {
                        status.addElement(new ExceptionElement(new BarcodeException("Barcode is higher than allowed")));
                    }
                    clip = true;
                }
                if (clip) {
                    result.setSuccessful(false);
                    image = ImageUtils.clip(image, new Rectangle(Math.min(barcodeImage.getBarcodeWidth(), maxWidthPx), Math.min(barcodeImage.getBarcodeHeight(), maxHeightPx)), 2);
                }
                result.setImage(image);
                return result;
            }
            catch (ConfigurationException e) {
                result.setSuccessful(false);
                if (this.verbose) {
                    status.addElement(new ExceptionElement(new BarcodeException(e.getMessage(), e.getCause())));
                }
            }
            catch (org.krysalis.barcode4j.BarcodeException e) {
                result.setSuccessful(false);
                if (this.verbose) {
                    status.addElement(new ExceptionElement(new BarcodeException(e.getMessage(), e.getCause())));
                }
            }
            catch (IOException e) {
                result.setSuccessful(false);
                if (this.verbose) {
                    status.addElement(new ExceptionElement(new BarcodeException(e.getMessage(), e.getCause())));
                }
            }
            catch (OptionException e) {
                result.setSuccessful(false);
                if (this.verbose) {
                    status.addElement(new ExceptionElement(new BarcodeException(e.getMessage(), e.getCause())));
                }
            }
            catch (IllegalArgumentException e) {
                result.setSuccessful(false);
                if (this.verbose) {
                    status.addElement(new ExceptionElement(new BarcodeException(e.getMessage(), e.getCause())));
                }
            }
            catch (BarcodeException e) {
                result.setSuccessful(false);
                if (this.verbose) {
                    status.addElement(new ExceptionElement(e));
                }
            }
            catch (Exception e) {
                result.setSuccessful(false);
                if (!this.verbose) break block24;
                status.addElement(new ExceptionElement(e));
            }
        }
        return result;
    }

    protected abstract Configuration createBarcodeConfiguration(double var1, double var3) throws BarcodeException, OptionException;

    public int getFontSizePt() throws OptionException {
        return this.optionContainer.getIntegerOptionValue("fontSizePt");
    }

    public void setFontSizePt(int fontSizePt) throws OptionException {
        this.optionContainer.setOption("fontSizePt", fontSizePt);
    }

    public String getFontName() throws OptionException {
        return this.optionContainer.getStringOptionValue("fontName");
    }

    public void setFontName(String fontName) throws OptionException {
        this.optionContainer.setOption("fontName", fontName);
    }

    public int getQuietZoneFactor() throws OptionException {
        return this.optionContainer.getIntegerOptionValue("quietZoneFactor");
    }

    public void setQuietZoneFactor(int quietZoneFactor) throws OptionException {
        this.optionContainer.setOption("quietZoneFactor", quietZoneFactor);
    }

    public boolean isQuietZoneEnabled() throws OptionException {
        return this.optionContainer.getBooleanOptionValue("quietZoneEnabled");
    }

    public void setQuietZoneEnabled(boolean quietZoneEnabled) throws OptionException {
        this.optionContainer.setOption("quietZoneEnabled", quietZoneEnabled);
    }

    public boolean isHumanReadableEnabled() throws OptionException {
        return this.optionContainer.getBooleanOptionValue("humanReadableEnabled");
    }

    public void setHumanReadableEnabled(boolean humanReadableEnabled) throws OptionException {
        this.optionContainer.setOption("humanReadableEnabled", humanReadableEnabled);
    }

    public HumanReadablePlacement getHumanReadablePlacement() throws OptionException {
        return this.optionContainer.getHumanReadablePlacementOptionValue("humanReadablePlacement");
    }

    public void setHumanReadablePlacement(HumanReadablePlacement humanReadablePlacement) throws OptionException {
        this.optionContainer.setOption("humanReadablePlacement", humanReadablePlacement);
    }

    public int getScale() throws OptionException {
        return this.optionContainer.getIntegerOptionValue("scale");
    }

    public void setScale(int scale) throws OptionException {
        this.optionContainer.setOption("scale", scale);
    }

    public void setAutoscale(boolean autoscale) throws OptionException {
        this.optionContainer.setOption("autoscale", autoscale);
    }

    public boolean isAutoscale() throws OptionException {
        return this.optionContainer.getBooleanOptionValue("autoscale");
    }

    public static enum ChecksumMode {
        ADD,
        CHECK,
        IGNORE,
        AUTO;

    }

    public static enum HumanReadablePlacement {
        BOTTOM,
        TOP,
        NONE;

    }
}

