/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.authentication;

import at.mrdevelopment.toolkit.authentication.Role;

public interface UserId {
    public static final UserId SYSTEM = new SystemUser();
    public static final UserId NONE = new NoneUser();

    public Long getId();

    public String getUsername();

    public Role getRole();

    public boolean isAuthorized();

    public static class NoneUser
    implements UserId {
        private static final String USERNAME = "";

        private NoneUser() {
        }

        @Override
        public Long getId() {
            return null;
        }

        @Override
        public String getUsername() {
            return USERNAME;
        }

        @Override
        public Role getRole() {
            return Role.NONE;
        }

        @Override
        public boolean isAuthorized() {
            return false;
        }
    }

    public static class SystemUser
    implements UserId {
        private static final String USERNAME = "system";

        private SystemUser() {
        }

        @Override
        public Long getId() {
            return null;
        }

        @Override
        public String getUsername() {
            return USERNAME;
        }

        @Override
        public Role getRole() {
            return Role.SYSTEM;
        }

        @Override
        public boolean isAuthorized() {
            return true;
        }
    }
}

