/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.authentication;

import at.mrdevelopment.toolkit.authentication.Authenticator;
import at.mrdevelopment.toolkit.authentication.PasswordProvider;
import at.mrdevelopment.toolkit.authentication.Role;
import at.mrdevelopment.toolkit.authentication.UserId;
import at.mrdevelopment.toolkit.http.RequestUser;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.security.Password;
import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;

public class HashAuthenticator
implements Authenticator {
    static ESLLogger logger = ESLLogger.getLogger(HashAuthenticator.class);
    private PasswordProvider passwordProvider;
    private Role role;

    public HashAuthenticator(PasswordProvider passwordProvider, Role role) throws NullPointerException {
        this.checkNotNull(passwordProvider);
        this.checkNotNull((Object)role);
        this.passwordProvider = passwordProvider;
        this.role = role;
    }

    @Override
    public UserId authorize(String username, String password) {
        Password passwordForUser = this.passwordProvider.getPassword(username);
        if (passwordForUser != null) {
            try {
                if (passwordForUser.verify(password)) {
                    return new RequestUser(this.role, username);
                }
            }
            catch (UnsupportedEncodingException exc) {
                logger.logException(exc);
            }
            catch (NoSuchAlgorithmException exc) {
                logger.logException(exc);
            }
        }
        return UserId.NONE;
    }

    private void checkNotNull(Object object) throws NullPointerException {
        if (object == null) {
            throw new NullPointerException();
        }
    }
}

