/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit;

import org.apache.commons.lang.StringUtils;

public class Version
implements Comparable<Version> {
    public static final Version UNDEFINED = new Version(0, 0, 0);
    private final byte mainRelease;
    private final byte subRelease;
    private final byte patchLevel;
    private final int build;
    private final String branch;

    public static Version fromString(String versionString) throws IllegalArgumentException, NumberFormatException {
        byte patchLevel;
        String[] parts = StringUtils.split((String)versionString, (String)".");
        if (parts.length != 3) {
            throw new IllegalArgumentException(String.format("Malformed version string %s", versionString));
        }
        byte mainRelease = Byte.parseByte(parts[0]);
        byte subRelease = Byte.parseByte(parts[1]);
        String branch = null;
        String[] patchLevelAndBranch = StringUtils.split((String)parts[2], (String)"-");
        if (patchLevelAndBranch.length == 1) {
            patchLevel = Byte.parseByte(patchLevelAndBranch[0]);
        } else if (patchLevelAndBranch.length == 2) {
            patchLevel = Byte.parseByte(patchLevelAndBranch[0]);
            branch = patchLevelAndBranch[1];
        } else {
            throw new IllegalArgumentException(String.format("Malformed version string %s", versionString));
        }
        return new Version(mainRelease, subRelease, patchLevel, branch);
    }

    public static Version fromByte(int versionByte) {
        byte mainRelease = (byte)((versionByte & 0xC0) >> 6);
        byte subRelease = (byte)((versionByte & 0x30) >> 4);
        byte patchLevel = (byte)(versionByte & 0xF);
        return new Version(mainRelease, subRelease, patchLevel);
    }

    public Version(byte mainRelease, byte subRelease, byte patchLevel) throws IllegalArgumentException {
        this(mainRelease, subRelease, patchLevel, 0, null);
    }

    public Version(byte mainRelease, byte subRelease, byte patchLevel, String branch) throws IllegalArgumentException {
        this(mainRelease, subRelease, patchLevel, 0, branch);
    }

    public Version(Version version, int build) {
        this(version.mainRelease, version.subRelease, version.patchLevel, build, version.branch);
    }

    public Version(byte mainRelease, byte subRelease, byte patchLevel, int build, String branch) throws IllegalArgumentException {
        if (mainRelease < 0 || subRelease < 0 || patchLevel < 0 || build < 0) {
            throw new IllegalArgumentException(String.format("Illegal version %d.%d.%d_%d", mainRelease, subRelease, patchLevel, build));
        }
        this.mainRelease = mainRelease;
        this.subRelease = subRelease;
        this.patchLevel = patchLevel;
        this.build = build;
        this.branch = branch;
    }

    public byte getMainRelease() {
        return this.mainRelease;
    }

    public byte getSubRelease() {
        return this.subRelease;
    }

    public byte getPatchLevel() {
        return this.patchLevel;
    }

    public int getBuild() {
        return this.build;
    }

    public String getBranch() {
        return this.branch;
    }

    public boolean isNewer(Version other) {
        return this.toLong() > other.toLong();
    }

    public boolean isOlder(Version other) {
        return this.toLong() < other.toLong();
    }

    public boolean isEqualOlder(Version other) {
        return this.toLong() <= other.toLong();
    }

    public boolean isEqual(Version other) {
        return this.toLong() == other.toLong();
    }

    public boolean isEqualOrNewer(Version other) {
        return this.toLong() >= other.toLong();
    }

    public String getVersionString() {
        return String.format("%d.%d.%d%s", this.mainRelease, this.subRelease, this.patchLevel, this.getBranchString());
    }

    private String getBranchString() {
        return this.branch != null ? String.format("-%s", this.branch) : "";
    }

    public long toLong() {
        return (long)this.mainRelease << 48 | (long)this.subRelease << 40 | (long)this.patchLevel << 32 | (long)this.build;
    }

    public String toString() {
        return this.getVersionString();
    }

    @Override
    public int compareTo(Version other) {
        if (other.mainRelease < this.mainRelease) {
            return -1;
        }
        if (other.mainRelease > this.mainRelease) {
            return 1;
        }
        if (other.subRelease < this.subRelease) {
            return -1;
        }
        if (other.subRelease > this.subRelease) {
            return 1;
        }
        if (other.patchLevel < this.patchLevel) {
            return -1;
        }
        if (other.patchLevel > this.patchLevel) {
            return 1;
        }
        return 0;
    }
}

