/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit;

import at.mrdevelopment.toolkit.CompareOperator;
import at.mrdevelopment.toolkit.Version;
import org.apache.commons.lang.StringUtils;

public class RequiredVersion {
    private final CompareOperator compareOperator;
    private final Version requiredVersion;

    public RequiredVersion(CompareOperator compareOperator, Version requiredVersion) {
        this.compareOperator = compareOperator;
        this.requiredVersion = requiredVersion;
    }

    public boolean match(Comparable<Version> version) {
        return this.compareOperator.compare(version, this.requiredVersion);
    }

    public String toString() {
        return String.format("%s%s", this.compareOperator.getOperator(), this.requiredVersion.getVersionString());
    }

    public static RequiredVersion fromString(String attribute) throws IllegalArgumentException, NumberFormatException {
        CompareOperator operator = null;
        if (StringUtils.startsWith((String)attribute, (String)CompareOperator.GREATER_EQUAL.getOperator())) {
            operator = CompareOperator.GREATER_EQUAL;
        } else if (StringUtils.startsWith((String)attribute, (String)CompareOperator.LOWER_EQUAL.getOperator())) {
            operator = CompareOperator.LOWER_EQUAL;
        } else if (StringUtils.startsWith((String)attribute, (String)CompareOperator.NOT_EQUAL.getOperator())) {
            operator = CompareOperator.NOT_EQUAL;
        } else if (StringUtils.startsWith((String)attribute, (String)CompareOperator.GREATER_THAN.getOperator())) {
            operator = CompareOperator.GREATER_THAN;
        } else if (StringUtils.startsWith((String)attribute, (String)CompareOperator.LOWER_THAN.getOperator())) {
            operator = CompareOperator.LOWER_THAN;
        } else if (StringUtils.startsWith((String)attribute, (String)CompareOperator.EQUAL.getOperator())) {
            operator = CompareOperator.EQUAL;
        } else if (StringUtils.isNumeric((String)attribute.substring(0, 0))) {
            operator = CompareOperator.EQUAL;
        } else {
            throw new IllegalArgumentException(String.format("Wrong required version format: %s", attribute));
        }
        String versionString = StringUtils.remove((String)attribute, (String)operator.getOperator());
        Version version = Version.fromString(versionString);
        return new RequiredVersion(operator, version);
    }
}

