/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class NetworkAddressUtils {
    public static InetAddress networkPrefixToSubnetMask(int networkPrefixLength) throws UnknownHostException {
        long subnetMaskBits = 0xFFFFFFFFL << 32 - networkPrefixLength & 0xFFFFFFFFL;
        byte[] subnetMaskBytes = new byte[]{(byte)((subnetMaskBits & 0xFF000000L) >> 24), (byte)((subnetMaskBits & 0xFF0000L) >> 16), (byte)((subnetMaskBits & 0xFF00L) >> 8), (byte)((subnetMaskBits & 0xFFL) >> 0)};
        return Inet4Address.getByAddress(subnetMaskBytes);
    }

    public static InetAddress calculateBroadcastAddress(Inet4Address ipAddress, int networkPrefixLength) throws UnknownHostException {
        long invertedSubnetMaskBits = 0xFFFFFFFFL >> networkPrefixLength;
        byte[] addressBytes = ipAddress.getAddress();
        byte[] broadcastBytes = new byte[]{(byte)((long)addressBytes[0] | (invertedSubnetMaskBits & 0xFF000000L) >> 24), (byte)((long)addressBytes[1] | (invertedSubnetMaskBits & 0xFF0000L) >> 16), (byte)((long)addressBytes[2] | (invertedSubnetMaskBits & 0xFF00L) >> 8), (byte)((long)addressBytes[3] | (invertedSubnetMaskBits & 0xFFL) >> 0)};
        return Inet4Address.getByAddress(broadcastBytes);
    }

    public static String hardwareAddressToString(byte[] hardwareAddress) {
        StringBuilder buffer = new StringBuilder();
        for (int index = 0; index < hardwareAddress.length; ++index) {
            buffer.append(String.format("%02X%s", hardwareAddress[index], index < hardwareAddress.length - 1 ? ":" : ""));
        }
        return buffer.toString();
    }
}

