/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit;

import org.apache.commons.lang.BooleanUtils;

public class ConversionUtils {
    private static final String MEGABYTE_SUFFIX = " MB";
    private static final String KILOBYTE_SUFFIX = " kB";

    public static String toMegaByte(long bytes) {
        long megaBytes = bytes / 1024L / 1024L;
        return String.format("%d%s", megaBytes, MEGABYTE_SUFFIX);
    }

    public static String toKiloByte(long bytes) {
        long kiloBytes = bytes / 1024L;
        return String.format("%d%s", kiloBytes, KILOBYTE_SUFFIX);
    }

    public static String toHumanReadableBytes(long bytes) {
        if (bytes > 0x100000L) {
            return ConversionUtils.toMegaByte(bytes);
        }
        return ConversionUtils.toKiloByte(bytes);
    }

    public static long toByte(String megaByteString) {
        long megaBytes = Long.parseLong(megaByteString.trim().replace(MEGABYTE_SUFFIX, ""));
        return megaBytes * 1024L * 1024L;
    }

    public static long toMillis(int minutes) {
        return (long)minutes * 60L * 1000L;
    }

    public static boolean toBoolean(String str) {
        try {
            int intValue = Integer.valueOf(str);
            return BooleanUtils.toBoolean((int)intValue);
        }
        catch (NumberFormatException exc) {
            return BooleanUtils.toBoolean((String)str);
        }
    }
}

