/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit;

import at.mrdevelopment.toolkit.log.ESLLogger;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FilenameUtils;

public class ClassLoaderBuilder {
    static ESLLogger logger = ESLLogger.getLogger(ClassLoaderBuilder.class);
    private final List<File> classpath = new ArrayList<File>();

    public void addDirectory(File directory) {
        if (!directory.isDirectory()) {
            return;
        }
        if (!directory.exists()) {
            return;
        }
        this.classpath.add(directory);
    }

    public void addJarsInDirectory(File directory) {
        File[] files;
        if (!directory.isDirectory()) {
            return;
        }
        if (!directory.exists()) {
            return;
        }
        for (File file : files = directory.listFiles()) {
            if (!FilenameUtils.isExtension((String)file.getPath(), (String)"jar")) continue;
            this.classpath.add(file);
        }
    }

    public ClassLoader getClassLoader() {
        try {
            URL[] jars = new URL[this.classpath.size()];
            for (int index = 0; index < this.classpath.size(); ++index) {
                jars[index] = this.classpath.get(index).toURI().toURL();
                logger.info("Adding %s to classpath", jars[index]);
            }
            return new URLClassLoader(jars, ClassLoader.getSystemClassLoader());
        }
        catch (MalformedURLException exc) {
            throw new RuntimeException(exc);
        }
    }
}

