/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit;

import java.math.BigInteger;

public class Base58 {
    private static final String ALPHABET = "123456789abcdefghijkmnopqrstuvwxyzABCDEFGHJKLMNPQRSTUVWXYZ";
    private static final BigInteger BASE = BigInteger.valueOf(58L);

    public static String encode(byte[] input) {
        BigInteger bi = new BigInteger(1, input);
        StringBuffer s = new StringBuffer();
        while (bi.compareTo(BASE) >= 0) {
            BigInteger mod = bi.mod(BASE);
            s.insert(0, ALPHABET.charAt(mod.intValue()));
            bi = bi.subtract(mod).divide(BASE);
        }
        s.insert(0, ALPHABET.charAt(bi.intValue()));
        for (byte anInput : input) {
            if (anInput != 0) break;
            s.insert(0, ALPHABET.charAt(0));
        }
        return s.toString();
    }

    public static byte[] decode(String input) {
        if (input.length() == 0) {
            return null;
        }
        BigInteger decoded = Base58.decodeToBigInteger(input);
        if (decoded == null) {
            return null;
        }
        byte[] bytes = decoded.toByteArray();
        boolean stripSignByte = bytes.length > 1 && bytes[0] == 0 && bytes[1] < 0;
        int leadingZeros = 0;
        for (int i = 0; i < input.length() && input.charAt(i) == ALPHABET.charAt(0); ++i) {
            ++leadingZeros;
        }
        byte[] tmp = new byte[bytes.length - (stripSignByte ? 1 : 0) + leadingZeros];
        System.arraycopy(bytes, stripSignByte ? 1 : 0, tmp, leadingZeros, tmp.length - leadingZeros);
        return tmp;
    }

    private static BigInteger decodeToBigInteger(String input) {
        BigInteger bi = BigInteger.valueOf(0L);
        for (int i = input.length() - 1; i >= 0; --i) {
            int alphaIndex = ALPHABET.indexOf(input.charAt(i));
            if (alphaIndex == -1) {
                return null;
            }
            bi = bi.add(BigInteger.valueOf(alphaIndex).multiply(BASE.pow(input.length() - 1 - i)));
        }
        return bi;
    }

    public static String encodeWithChecksum(byte[] input) {
        String encoded = Base58.encode(input);
        return encoded + Base58.calculateCheckSum(encoded);
    }

    public static char calculateCheckSum(String encoded) {
        int sumOdd = 0;
        int sumEven = 0;
        for (int index = 0; index < encoded.length(); ++index) {
            int alphaIndex = ALPHABET.indexOf(encoded.charAt(index));
            if (index % 2 == 0) {
                sumOdd += alphaIndex;
                continue;
            }
            sumEven += alphaIndex;
        }
        return ALPHABET.charAt((sumEven + 3 * sumOdd) % 58);
    }
}

