/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.xml;

import at.mrdevelopment.esl.core.ServiceStatus;
import at.mrdevelopment.esl.core.problem.QueryProblem;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.problem.MessageProblem;
import at.mrdevelopment.toolkit.problem.Problem;
import at.mrdevelopment.toolkit.problem.ProblemSeverity;
import at.mrdevelopment.toolkit.xml.SerializeException;
import at.mrdevelopment.toolkit.xml.XMLSerializer;
import at.mrdevelopment.toolkit.xml.XMLToolkit;
import java.io.InputStream;
import java.text.ParseException;
import java.util.Collection;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ServiceStatusXMLSerializer
implements XMLSerializer<ServiceStatus> {
    private final XMLToolkit xmlToolkit = new XMLToolkit();

    public Element toXML(Document document, ServiceStatus serviceStatus) {
        Element element = document.createElement("service-status");
        element.setAttribute("name", serviceStatus.getServiceName());
        this.addProperties(document, element, serviceStatus.getProperties());
        this.addProblems(document, element, serviceStatus.getProblems());
        return element;
    }

    public Document toXML(ServiceStatus serviceStatus) {
        Document document = this.xmlToolkit.newDocument();
        document.appendChild(this.toXML(document, serviceStatus));
        return document;
    }

    public Document toXML(Collection<Problem> problems) {
        Document document = this.xmlToolkit.newDocument();
        Element element = document.createElement("problems");
        this.addProblems(document, element, problems);
        document.appendChild(element);
        return document;
    }

    private void addProperties(Document document, Element element, Map<String, String> properties) {
        for (Map.Entry<String, String> property : properties.entrySet()) {
            Element propertyElement = document.createElement("property");
            propertyElement.setAttribute("key", property.getKey());
            propertyElement.setTextContent(property.getValue());
            element.appendChild(propertyElement);
        }
    }

    private void addProblems(Document document, Element element, Collection<Problem> problems) {
        for (Problem problem : problems) {
            Element problemElement = document.createElement("problem");
            problemElement.setAttribute("severity", problem.getSeverity().toString());
            problemElement.setAttribute("identifier", problem.getIdentifier());
            problemElement.setAttribute("message", problem.getMessage());
            if (problem instanceof QueryProblem) {
                QueryProblem queryProblem = (QueryProblem)problem;
                problemElement.setAttribute("query-url", queryProblem.getQueryUrl());
                problemElement.setAttribute("record-class", queryProblem.getRecordClass().getSimpleName());
            }
            element.appendChild(problemElement);
        }
    }

    public ServiceStatus parseXML(InputStream xmlInputStream) throws SerializeException {
        Element root = this.xmlToolkit.getDocumentRootFromInputStream(xmlInputStream);
        try {
            return this.parseServiceStatusFromXML(root);
        }
        catch (Exception exc) {
            throw new SerializeException((Throwable)exc);
        }
    }

    private ServiceStatus parseServiceStatusFromXML(Element element) throws ParseException, ClassNotFoundException {
        ServiceStatus serviceStatus = new ServiceStatus(element.getAttribute("name"));
        NodeList properties = element.getElementsByTagName("property");
        for (int index = 0; index < properties.getLength(); ++index) {
            Element propertyElement = (Element)properties.item(index);
            String key = propertyElement.getAttribute("key");
            String value = propertyElement.getTextContent();
            serviceStatus.setProperty(key, value);
        }
        NodeList problems = element.getElementsByTagName("problem");
        for (int index = 0; index < problems.getLength(); ++index) {
            Element problemElement = (Element)problems.item(index);
            ProblemSeverity severity = ProblemSeverity.valueOf((String)problemElement.getAttribute("severity"));
            String identifier = problemElement.getAttribute("identifier");
            String message = problemElement.getAttribute("message");
            String queryUrl = problemElement.getAttribute("query-url");
            String recordClass = problemElement.getAttribute("record-class");
            if (queryUrl == null || queryUrl.isEmpty() || recordClass == null || recordClass.isEmpty()) {
                MessageProblem problem = new MessageProblem(severity, identifier, message);
                serviceStatus.addProblem((Problem)problem);
                continue;
            }
            String recordClassFullName = "at.mrdevelopment.esl.persistence.record." + recordClass;
            QueryProblem problem = new QueryProblem(severity, identifier, message, queryUrl, Class.forName(recordClassFullName));
            serviceStatus.addProblem(problem);
        }
        return serviceStatus;
    }
}

