/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.xml;

import at.mrdevelopment.Pair;
import at.mrdevelopment.esl.core.ServiceAddress;
import at.mrdevelopment.esl.type.WakeupStatistic;
import at.mrdevelopment.esl.wireless.Address;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.Range;
import at.mrdevelopment.toolkit.xml.SerializeException;
import at.mrdevelopment.toolkit.xml.XMLToolkit;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ServiceAddressAndLabelXMLSerializer {
    public static final String TYPE_SERVER = "server";
    public static final String TYPE_AP = "accesspoint";
    public static final String TYPE_SELECTED = "selected";
    public static final String TYPE_NOT_SELECTED = "not selected";
    private final XMLToolkit xmlToolkit = new XMLToolkit();

    public List<Pair<Range<String>, Boolean>> parseLabelData(File labelDataFile) throws FileNotFoundException, SerializeException {
        Element root = this.xmlToolkit.getDocumentRootFromFile(labelDataFile);
        ArrayList<Pair<Range<String>, Boolean>> labelRangeList = new ArrayList<Pair<Range<String>, Boolean>>();
        NodeList labelRangeNodeList = root.getElementsByTagName("LabelRange");
        if (labelRangeNodeList != null && labelRangeNodeList.getLength() > 0) {
            for (int i = 0; i < labelRangeNodeList.getLength(); ++i) {
                Element labelRangeElement = (Element)labelRangeNodeList.item(i);
                Range labelRange = new Range((Comparable)((Object)labelRangeElement.getAttribute("from")), (Comparable)((Object)labelRangeElement.getAttribute("to")));
                boolean selected = Boolean.valueOf(labelRangeElement.getAttribute(TYPE_SELECTED));
                labelRangeList.add((Pair<Range<String>, Boolean>)new Pair((Object)labelRange, (Object)selected));
            }
        }
        return labelRangeList;
    }

    public void storeLabelData(List<Pair<Range<String>, Boolean>> labels, File labelDataFile) throws SerializeException {
        try {
            Document document = this.xmlToolkit.newDocument();
            Element labelListElement = document.createElement("LabelRangeList");
            for (Pair<Range<String>, Boolean> rangePair : labels) {
                Element labelRangeElement = document.createElement("LabelRange");
                labelRangeElement.setAttribute("from", (String)((Object)((Range)rangePair.getFirst()).getFrom()));
                labelRangeElement.setAttribute("to", (String)((Object)((Range)rangePair.getFirst()).getTo()));
                labelRangeElement.setAttribute(TYPE_SELECTED, String.valueOf(rangePair.getSecond()));
                labelListElement.appendChild(labelRangeElement);
            }
            document.appendChild(labelListElement);
            this.writeFile(document, labelDataFile);
        }
        catch (Exception exc) {
            throw new SerializeException((Throwable)exc);
        }
    }

    public List<WakeupStatistic> parseLabelWakeupStatistics(File labelDataFile) throws FileNotFoundException, SerializeException {
        List<Pair<Range<String>, Boolean>> labelRangeList = this.parseLabelData(labelDataFile);
        ArrayList<WakeupStatistic> wakeupStatisticList = new ArrayList<WakeupStatistic>();
        for (Pair<Range<String>, Boolean> labelRange : labelRangeList) {
            long from = Address.fromString((String)((Object)((Range)labelRange.getFirst()).getFrom())).getHardwareAddress();
            long to = Address.fromString((String)((Object)((Range)labelRange.getFirst()).getTo())).getHardwareAddress();
            for (long i = from; i <= to; ++i) {
                wakeupStatisticList.add(new WakeupStatistic(Address.fromId(i), 0));
            }
        }
        return wakeupStatisticList;
    }

    private void writeFile(Document document, File file) throws SerializeException {
        try {
            DOMSource xmlSource = new DOMSource(document.getDocumentElement());
            StreamResult xmlResult = new StreamResult(file.toURI().getPath());
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            transformer.transform(xmlSource, xmlResult);
        }
        catch (Exception exc) {
            throw new SerializeException((Throwable)exc);
        }
    }

    public void storeServiceAddress(Map<String, Collection<ServiceAddress>> serviceAddresses, File serviceAddressesFile) throws SerializeException {
        Document document = this.xmlToolkit.newDocument();
        Element serviceAddressListElement = document.createElement("ServiceAddressList");
        for (String type : serviceAddresses.keySet()) {
            for (ServiceAddress serviceAddress : serviceAddresses.get(type)) {
                Element serviceAddressElement = this.toXML(serviceAddress, type, document);
                serviceAddressListElement.appendChild(serviceAddressElement);
            }
        }
        document.appendChild(serviceAddressListElement);
        this.writeFile(document, serviceAddressesFile);
    }

    private Element toXML(ServiceAddress serviceAddress, String type, Document document) {
        Element serviceAddressElement = document.createElement("ServiceAddress");
        serviceAddressElement.setAttribute("type", type);
        serviceAddressElement.setAttribute("host", serviceAddress.getHost());
        serviceAddressElement.setAttribute("port", String.valueOf(serviceAddress.getPort()));
        return serviceAddressElement;
    }

    public Map<String, Collection<ServiceAddress>> parseServiceAddresses(File serviceAddressesFile) throws FileNotFoundException, SerializeException {
        HashMap<String, Collection<ServiceAddress>> serviceAddressMap = new HashMap<String, Collection<ServiceAddress>>();
        Element root = this.xmlToolkit.getDocumentRootFromFile(serviceAddressesFile);
        NodeList serviceAddressNodeList = root.getElementsByTagName("ServiceAddress");
        if (serviceAddressNodeList != null && serviceAddressNodeList.getLength() > 0) {
            for (int i = 0; i < serviceAddressNodeList.getLength(); ++i) {
                Element serviceAddressElement = (Element)serviceAddressNodeList.item(i);
                String type = serviceAddressElement.getAttribute("type");
                String host = serviceAddressElement.getAttribute("host");
                int port = Integer.valueOf(serviceAddressElement.getAttribute("port"));
                if (!serviceAddressMap.containsKey(type)) {
                    serviceAddressMap.put(type, new ArrayList());
                }
                ((Collection)serviceAddressMap.get(type)).add(new ServiceAddress(false, host, port));
            }
        }
        return serviceAddressMap;
    }
}

