/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.xml;

import at.mrdevelopment.esl.admin.platform.BackendTaskInfo;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.xml.XMLSerializer;
import at.mrdevelopment.toolkit.xml.XMLToolkit;
import java.util.Collection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BackendTaskInfoXMLSerializer
implements XMLSerializer<BackendTaskInfo> {
    private final XMLToolkit xmlToolkit = new XMLToolkit();

    public Document toXML(Collection<BackendTaskInfo> tasks) {
        Document document = this.xmlToolkit.newDocument();
        Element element = document.createElement("backend-tasks");
        for (BackendTaskInfo task : tasks) {
            Element taskElement = document.createElement("task");
            taskElement.setAttribute("id", Long.toString(task.getId()));
            taskElement.setAttribute("task", task.getTaskName());
            if (task.getTaskArguments() != null) {
                taskElement.setAttribute("arguments", task.getTaskArguments());
            }
            if (task.getCreateTime() != null) {
                taskElement.setAttribute("create-time", this.xmlToolkit.formatTime(task.getCreateTime()));
            }
            if (task.getStartTime() != null) {
                taskElement.setAttribute("start-time", this.xmlToolkit.formatTime(task.getStartTime()));
            }
            if (task.getEndTime() != null) {
                taskElement.setAttribute("end-time", this.xmlToolkit.formatTime(task.getEndTime()));
            }
            taskElement.setAttribute("status", task.getStatus().toString());
            element.appendChild(taskElement);
        }
        document.appendChild(element);
        return document;
    }
}

