/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.xml;

import at.mrdevelopment.esl.wireless.Address;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.xml.SerializeException;
import at.mrdevelopment.toolkit.xml.XMLSerializer;
import at.mrdevelopment.toolkit.xml.XMLToolkit;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class AddressXMLSerializer
implements XMLSerializer<Address> {
    private XMLToolkit xmlToolkit = new XMLToolkit();

    public Document toXML(Collection<Address> labels) {
        Document document = this.xmlToolkit.newDocument();
        Element element = document.createElement("labels");
        for (Address label : labels) {
            Element labelElement = document.createElement("label");
            labelElement.setAttribute("id", label.toString());
            element.appendChild(labelElement);
        }
        document.appendChild(element);
        return document;
    }

    public Set<Address> parseXML(InputStream inputStream) throws SerializeException {
        HashSet<Address> addresses = new HashSet<Address>();
        Element root = this.xmlToolkit.getDocumentRootFromInputStream(inputStream);
        NodeList labelNodeList = root.getElementsByTagName("label");
        for (int index = 0; index < labelNodeList.getLength(); ++index) {
            Element labelElement = (Element)labelNodeList.item(index);
            addresses.add(Address.fromString(labelElement.getAttribute("id")));
        }
        return addresses;
    }
}

