/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.wireless;

import at.mrdevelopment.esl.core.Page;
import at.mrdevelopment.esl.core.PowerStatus;
import at.mrdevelopment.esl.core.SyncQuality;
import at.mrdevelopment.esl.type.LabelErrors;
import at.mrdevelopment.toolkit.Version;
import org.joda.time.DateTime;

public class Ping {
    private final DateTime time = DateTime.now();
    private final Version firmwareVersion;
    private final SyncQuality syncQuality;
    private final boolean keyUnset;
    private final boolean keysNotProgrammed;
    private final PowerStatus powerStatus;
    private final Page currentPage;
    private final LabelErrors labelErrors;

    public static Ping loadPing(int firmwareVersionByte, int syncQualityByte, int statusFlags, int errorFlags) {
        Version firmwareVersion = Version.fromByte((int)firmwareVersionByte);
        SyncQuality syncQuality = new SyncQuality(syncQualityByte);
        boolean keyUnset = (statusFlags & 0x20) > 0;
        boolean keysNotProgrammed = (statusFlags & 0x10) > 0;
        PowerStatus powerStatus = PowerStatus.valueOf((statusFlags & 0xC0) >> 6);
        Page currentPage = Page.valueOf(statusFlags & 0xF);
        LabelErrors labelErrors = new LabelErrors(errorFlags);
        return new Ping(firmwareVersion, syncQuality, keyUnset, keysNotProgrammed, powerStatus, currentPage, labelErrors);
    }

    public Ping(Version firmwareVersion, SyncQuality syncQuality, boolean keyUnset, boolean keysNotProgrammed, PowerStatus powerStatus, Page currentPage, LabelErrors labelErrors) {
        this.firmwareVersion = firmwareVersion;
        this.syncQuality = syncQuality;
        this.keyUnset = keyUnset;
        this.keysNotProgrammed = keysNotProgrammed;
        this.powerStatus = powerStatus;
        this.currentPage = currentPage;
        this.labelErrors = labelErrors;
    }

    public DateTime getTime() {
        return this.time;
    }

    public Version getFirmwareVersion() {
        return this.firmwareVersion;
    }

    public SyncQuality getSyncQuality() {
        return this.syncQuality;
    }

    public PowerStatus getPowerStatus() {
        return this.powerStatus;
    }

    public boolean isKeyUnset() {
        return this.keyUnset;
    }

    public boolean areKeysNotProgrammed() {
        return this.keysNotProgrammed;
    }

    public Page getCurrentPage() {
        return this.currentPage;
    }

    public LabelErrors getLabelErrors() {
        return this.labelErrors;
    }

    public String toString() {
        return String.format("firmwareVersion=%s, syncQuality=%d, keyUnset=%b, keysNotProgrammed=%b, powerStatus=%s, labelErrors=%d", new Object[]{this.firmwareVersion, this.syncQuality.getSyncQualityValue(), this.keyUnset, this.keysNotProgrammed, this.powerStatus, this.labelErrors.getErrorCode()});
    }
}

