/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.wireless;

import at.mrdevelopment.esl.wireless.Address;
import at.mrdevelopment.esl.wireless.RxMetrics;
import org.joda.time.DateTime;

public class Packet {
    private static final int SEND_TIME_MILLISECONDS = 3;
    private final Address receiverAddress;
    private final DateTime receiveTime;
    private final int sendTimeMilliseconds;
    private Address senderAddress = Address.UNDEFINED;
    private RxMetrics rxMetrics;

    public Packet(Address receiverAddress) {
        this(receiverAddress, 3);
    }

    public Packet(Address receiverAddress, int sendTimeMilliseconds) {
        this.receiverAddress = receiverAddress;
        this.receiveTime = DateTime.now();
        this.sendTimeMilliseconds = sendTimeMilliseconds;
    }

    public void setSenderAddress(Address senderAddress) {
        this.senderAddress = senderAddress;
    }

    public Address getSenderAddress() {
        return this.senderAddress;
    }

    public Address getReceiverAddress() {
        return this.receiverAddress;
    }

    public DateTime getTime() {
        return this.receiveTime;
    }

    public int getSendTime() {
        return this.sendTimeMilliseconds;
    }

    public int getRssi() {
        return this.rxMetrics.getRssi();
    }

    public int getLinkQuality() {
        return this.rxMetrics.getLqi();
    }

    public RxMetrics getRxMetrics() {
        return this.rxMetrics;
    }

    public void setRxMetrics(RxMetrics rxMetrics) {
        this.rxMetrics = rxMetrics;
    }

    public String toString() {
        return String.format("[%11s %s : %s]", this.getClass().getSimpleName(), this.senderAddress, this.receiverAddress);
    }
}

