/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.updatetask;

import at.mrdevelopment.esl.core.TransmissionStatistic;
import at.mrdevelopment.esl.core.UpdateTaskStatus;
import at.mrdevelopment.esl.type.UpdateError;
import at.mrdevelopment.esl.updatetask.TaskPriority;
import at.mrdevelopment.esl.wireless.Address;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.util.UUID;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;

public abstract class UpdateTask
implements Comparable<UpdateTask> {
    static ESLLogger logger = ESLLogger.getLogger(UpdateTask.class);
    private final UUID taskId;
    private final Address address;
    private final TaskPriority priority;
    private UpdateTaskStatus status;
    private UpdateError updateError;
    private TransmissionStatistic transmissionStatistic;
    private int revision;
    private DateTime createdAtTime;
    private DateTime updatedAtTime;
    private DateTime localTime;

    public UpdateTask(UUID taskId, Address address, TaskPriority priority) {
        this.taskId = taskId;
        this.address = address;
        this.priority = priority;
        this.status = UpdateTaskStatus.WAITING;
        this.updateError = null;
        this.transmissionStatistic = TransmissionStatistic.NO_STATISTIC;
        this.revision = 1;
        this.updatedAtTime = this.createdAtTime = DateTime.now();
        this.localTime = this.createdAtTime;
    }

    public UUID getTaskId() {
        return this.taskId;
    }

    public Address getAddress() {
        return this.address;
    }

    public TaskPriority getPriority() {
        return this.priority;
    }

    public UpdateTaskStatus getStatus() {
        return this.status;
    }

    public UpdateError getUpdateError() {
        return this.updateError;
    }

    public TransmissionStatistic getTransmissionStatistic() {
        return this.transmissionStatistic;
    }

    public boolean hasTransmissionStatistic() {
        return this.transmissionStatistic != TransmissionStatistic.NO_STATISTIC;
    }

    public int getRevision() {
        return this.revision;
    }

    public DateTime getCreatedAtTime() {
        return this.createdAtTime;
    }

    public DateTime getUpdatedAtTime() {
        return this.updatedAtTime;
    }

    public DateTime getLocalTime() {
        return this.localTime;
    }

    public int getSize() {
        return 0;
    }

    public boolean isFinished() {
        return this.status.isFinished();
    }

    public boolean isWaiting() {
        return this.status.isWaiting();
    }

    public boolean isSending() {
        return this.status.isSending();
    }

    public boolean isError() {
        return this.status.isUnsuccessful();
    }

    public boolean isSuccessful() {
        return this.status.isSuccessful();
    }

    public void changeStatus(UpdateTaskStatus status, UpdateError updateError, TransmissionStatistic transmissionStatistic) {
        this.changeStatus(status, updateError);
        this.setTransmissionStatistic(transmissionStatistic);
    }

    public void changeStatus(UpdateTaskStatus status, UpdateError updateError) {
        if (this.isFinished()) {
            logger.error("Changing status of finished updated task %s from %s to %s", new Object[]{this.taskId, this.status, status});
        }
        this.status = status;
        this.updateError = updateError;
        ++this.revision;
        this.updatedAtTime = DateTime.now();
    }

    protected void setTransmissionStatistic(TransmissionStatistic transmissionStatistic) {
        this.transmissionStatistic = transmissionStatistic != null ? transmissionStatistic : TransmissionStatistic.NO_STATISTIC;
    }

    protected void setStatus(UpdateTaskStatus status) {
        this.status = status;
    }

    protected void setUpdateError(UpdateError updateError) {
        this.updateError = updateError;
    }

    protected void setRevision(int revision) {
        this.revision = revision;
    }

    protected void setCreatedAtTime(DateTime createdAtTime) {
        this.createdAtTime = createdAtTime;
    }

    protected void setUpdatedAtTime(DateTime updatedAtTime) {
        this.updatedAtTime = updatedAtTime;
    }

    protected void setLocalTime(DateTime localTime) {
        this.localTime = localTime;
    }

    public String toString() {
        String timeStampString = DateTimeFormat.forStyle((String)"SM").print((ReadableInstant)new DateTime((Object)this.updatedAtTime));
        return String.format("[%s, %d] %s <%s>", new Object[]{timeStampString, this.revision, this.address, this.status});
    }

    @Override
    public int compareTo(UpdateTask other) {
        return this.updatedAtTime.compareTo((ReadableInstant)other.updatedAtTime);
    }

    public int hashCode() {
        return this.taskId.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof UpdateTask)) {
            return false;
        }
        UpdateTask other = (UpdateTask)object;
        if (this.taskId != other.taskId) {
            return false;
        }
        return this.revision == other.revision;
    }
}

