/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.updatetask;

import java.util.HashMap;
import java.util.Map;

public enum LabelSensor {
    TEMPERATURE_RAW_ADC_SENSOR(0, "Temperature ADC"),
    TEMPERATURE_SENSOR(1, "Temperature"),
    POWER_VOLTAGE_SENSOR(2, "Power Voltage"),
    MCU_SUPPLY_VOLTAGE_SENSOR(3, "MCU Supply Voltage"),
    BATTERY_RESISTANCE_SENSOR(4, "Battery Resistance"),
    LABEL_SENSOR_5(5, "Label Sensor 5"),
    LABEL_SENSOR_6(6, "Label Sensor 6"),
    LABEL_SENSOR_7(7, "Label Sensor 7"),
    LABEL_SENSOR_8(8, "Label Sensor 8"),
    LABEL_SENSOR_9(9, "Label Sensor 9"),
    LABEL_SENSOR_10(10, "Label Sensor 10"),
    LABEL_SENSOR_11(11, "Label Sensor 11"),
    LABEL_SENSOR_12(12, "Label Sensor 12"),
    LABEL_SENSOR_13(13, "Label Sensor 13"),
    LABEL_SENSOR_14(14, "Label Sensor 14");

    private static final Map<Integer, LabelSensor> labelSensors;
    private final int sensorId;
    private final String sensorName;

    public static LabelSensor fromId(int id) {
        return labelSensors.get(id);
    }

    private LabelSensor(int sensorId, String sensorName) {
        this.sensorId = sensorId;
        this.sensorName = sensorName;
    }

    public int getSensorId() {
        return this.sensorId;
    }

    public String getSensorName() {
        return this.sensorName;
    }

    static {
        labelSensors = new HashMap<Integer, LabelSensor>();
        for (LabelSensor sensor : LabelSensor.values()) {
            labelSensors.put(sensor.sensorId, sensor);
        }
    }
}

