/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.updatetask;

import at.mrdevelopment.esl.updatetask.DataUpdateTask;
import at.mrdevelopment.esl.updatetask.LabelKeys;
import at.mrdevelopment.esl.updatetask.TaskPriority;
import at.mrdevelopment.esl.wireless.Address;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class InitializeUpdateTask
extends DataUpdateTask {
    private final ArrayList<LabelKeys> keys = new ArrayList();
    private final ArrayList<String> values = new ArrayList();

    public InitializeUpdateTask(UUID taskId, Address address, TaskPriority priority, Map<LabelKeys, String> keys) {
        super(taskId, address, priority);
        for (Map.Entry<LabelKeys, String> key : keys.entrySet()) {
            this.addKey(key.getKey(), key.getValue());
        }
    }

    public InitializeUpdateTask(UUID taskId, Address address, TaskPriority priority) {
        super(taskId, address, priority);
    }

    @Override
    public boolean isCompressionAllowed() {
        return false;
    }

    public List<LabelKeys> getKeys() {
        return Collections.unmodifiableList(this.keys);
    }

    public void addKey(LabelKeys key, String value) {
        int index = this.keys.size();
        this.keys.add(index, key);
        this.values.add(index, value);
    }

    public String getKeyValue(LabelKeys key) {
        int index = this.keys.indexOf((Object)key);
        if (index == -1) {
            return "";
        }
        return this.values.get(index);
    }

    public byte[] getDataFrame() {
        String dataString = new String();
        dataString = dataString + this.getKeysAsString();
        byte[] dataByteArray = new byte[144];
        if (dataString.length() > 128) {
            // empty if block
        }
        dataByteArray[0] = (byte)dataString.length();
        dataByteArray[1] = -32;
        for (int i = 0; i < dataString.length(); i += 2) {
            dataByteArray[16 + i / 2] = (byte)(Integer.parseInt(dataString.substring(i, i + 1), 16) * 16);
            int n = 16 + i / 2;
            dataByteArray[n] = (byte)(dataByteArray[n] + (byte)Integer.parseInt(dataString.substring(i + 1, i + 2), 16));
        }
        return dataByteArray;
    }

    private String getKeysAsString() {
        String dataString = new String();
        String tmpKeyValue = this.getKeyValue(LabelKeys.PIN);
        if (tmpKeyValue.isEmpty()) {
            tmpKeyValue = "00000000000000000000000000000000";
        }
        dataString = dataString + tmpKeyValue + tmpKeyValue + tmpKeyValue + tmpKeyValue;
        tmpKeyValue = this.getKeyValue(LabelKeys.PUK);
        if (tmpKeyValue.isEmpty()) {
            tmpKeyValue = "00000000000000000000000000000000";
        }
        dataString = dataString + tmpKeyValue;
        tmpKeyValue = this.getKeyValue(LabelKeys.PSK);
        if (tmpKeyValue.isEmpty()) {
            tmpKeyValue = "00000000000000000000000000000000";
        }
        dataString = dataString + tmpKeyValue;
        return dataString;
    }
}

