/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.updatetask;

import at.mrdevelopment.esl.core.Page;
import at.mrdevelopment.esl.core.labeltype.DisplayDriving;
import at.mrdevelopment.esl.core.labeltype.LabelType;
import at.mrdevelopment.esl.updatetask.CompressedData;
import at.mrdevelopment.esl.updatetask.DataUpdateTask;
import at.mrdevelopment.esl.updatetask.TaskPriority;
import at.mrdevelopment.esl.wireless.Address;
import at.mrdevelopment.toolkit.encoding.DataEncoding;
import at.mrdevelopment.toolkit.image.ColorMapping;
import at.mrdevelopment.toolkit.image.ImageSerializer;
import at.mrdevelopment.toolkit.image.ImageUtils;
import at.mrdevelopment.toolkit.image.RawImage;
import at.mrdevelopment.toolkit.image.RawImageFactory;
import at.mrdevelopment.toolkit.image.RawImageType;
import at.mrdevelopment.toolkit.xml.SerializeException;
import java.awt.image.BufferedImage;
import java.util.UUID;

public class ImageUpdateTask
extends DataUpdateTask {
    private final RawImage image;
    private final Page page;
    private final boolean preload;
    private CompressedData preparedData;

    private ImageUpdateTask(UUID taskId, Address address, TaskPriority priority, RawImage image, Page page, boolean preload) {
        super(taskId, address, priority);
        this.image = image;
        this.page = page;
        this.preload = preload;
    }

    public ImageUpdateTask(UUID taskId, Address address, TaskPriority priority, BufferedImage image, LabelType labelType, Page page, boolean preload) {
        this(taskId, address, priority, RawImageFactory.newImage((BufferedImage)(labelType.isFlipImage() ? ImageUtils.flip((BufferedImage)image) : image), (RawImageType)labelType.getRawImageType(), (ColorMapping[])labelType.getColorMappings()), page, preload);
    }

    public ImageUpdateTask(UUID taskId, Address address, TaskPriority priority, String encodedImage, LabelType labelType, Page page, boolean preload) throws SerializeException {
        this(taskId, address, priority, encodedImage != null && !encodedImage.isEmpty() ? RawImageFactory.newImage((String)encodedImage, (RawImageType)labelType.getRawImageType(), (ColorMapping[])labelType.getColorMappings()) : null, page, preload);
    }

    public Page getPage() {
        return this.page;
    }

    public boolean isPreload() {
        return this.preload;
    }

    public BufferedImage getImage() {
        return this.image.toBufferedImage();
    }

    public RawImage getRawImage() {
        return this.image;
    }

    public String getEncodedData() throws SerializeException {
        return ImageSerializer.toBase64String((BufferedImage)this.image.toBufferedImage());
    }

    @Override
    public boolean isCompressionAllowed() {
        return true;
    }

    @Override
    public int getSize() {
        return this.image.getSize();
    }

    public boolean hasPreparedData() {
        return this.preparedData != null;
    }

    public byte[] getData() {
        return this.preparedData.getData();
    }

    public boolean isCompressed() {
        return this.preparedData.isCompressed();
    }

    public void prepareDataForImage(DisplayDriving displayDriving, DataEncoding encoding) {
        this.preparedData = new CompressedData(displayDriving.toImage(this.image), encoding);
    }
}

