/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.type;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.collections15.CollectionUtils;
import org.apache.commons.collections15.Predicate;

public enum LabelError {
    ERROR_FLAG_OTHERS(1, "Other hardware related errors"),
    ERROR_FLAG_HIGH_TRANSMISSION_FAIL_RATE(2, "High transmission fail rate"),
    ERROR_FLAG_RESETS(4, "Unexpected resets"),
    ERROR_FLAG_FLASH_INTEGRITY(8, "Flash integrity errors"),
    ERROR_FLAG_TOTAL_TRANSMISSIONS(16, "Total number of specified transmissions exceeded"),
    ERROR_FLAG_TOTAL_DISPLAY_UPDATES(32, "Total number of specified display updates exceeded"),
    ERROR_FLAG_TEMPERATURE(64, "Display was updated at temperature out of specified range"),
    ERROR_FLAG_DISPLAY_UPDATE_FAILED(128, "Display failure during update");

    private final int flag;
    private final String description;

    private LabelError(int flag, String description) {
        this.flag = flag;
        this.description = description;
    }

    public int getCode() {
        return this.flag;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean hasError(int errorCode) {
        return (errorCode & this.flag) > 0;
    }

    public static Set<LabelError> getErrorsForCode(final int errorCode) {
        return (Set)CollectionUtils.select(Arrays.asList(LabelError.values()), (Predicate)new Predicate<LabelError>(){

            public boolean evaluate(LabelError labelError) {
                return labelError.hasError(errorCode);
            }
        }, new HashSet());
    }
}

