/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.type;

import at.mrdevelopment.esl.type.EANCode;

public class Gtin {
    private final long gtin;

    public static Gtin fromString(String gtin) throws NumberFormatException {
        return new Gtin(Long.parseLong(gtin));
    }

    public static Gtin fromLong(long gtin) {
        return new Gtin(gtin);
    }

    public static Gtin fromEan(EANCode ean) {
        return new Gtin(ean.getCode());
    }

    private Gtin(long gtin) {
        this.gtin = gtin;
    }

    public String toString() {
        return Long.toString(this.gtin);
    }

    public long toLong() {
        return this.gtin;
    }

    private int calculateCheckSum() {
        int sumOdd = 0;
        int sumEven = 0;
        String gtinString = Long.toString(this.gtin);
        for (int index = gtinString.length() - 2; index >= 0; --index) {
            int digit = Character.digit(gtinString.charAt(index), 10);
            if ((gtinString.length() - index) % 2 == 0) {
                sumOdd += digit;
                continue;
            }
            sumEven += digit;
        }
        return (10 - (sumEven + 3 * sumOdd) % 10) % 10;
    }

    public boolean isValid() {
        int checkSum = this.calculateCheckSum();
        return (long)checkSum == this.gtin % 10L;
    }

    public int hashCode() {
        return Long.valueOf(this.gtin).hashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        Gtin gtin = (Gtin)other;
        return this.gtin == gtin.gtin;
    }

    public static enum Type {
        GTIN14,
        GTIN13,
        GTIN12,
        GTIN8;

    }
}

