/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.tasks;

import at.mrdevelopment.toolkit.sql.SqlUtils;

public enum TaskType {
    IMAGE("Show image and store image to page"),
    PRELOAD_IMAGE("Store image to page without updating display (preloading image)"),
    FIRMWARE("Update label firmware"),
    SWITCH_PAGE("Show preloaded content of specified page on display"),
    REFRESH_DISPLAY("Refreshes the currently shown image on the display"),
    QUERY_SENSOR("Query sensor value"),
    PROGRAM_KEYS("Program Pin, Puk and Preshared Key"),
    SET_CONFIG("Update value of configuration entry"),
    GET_CONFIG("Get current value of configuration entry"),
    RESET_ALL_COUNTERS("Clear all counter values"),
    RESET_COUNTER("Clear counter value"),
    QUERY_COUNTER("Query counter value"),
    FORCE_CHANNEL_SCAN("Force label to scan for access points on all channels"),
    REBOOT("Force a reboot"),
    PING("Ping label (connection test)"),
    REGISTER_LABEL("Register label to network"),
    UNREGISTER_LABEL("Unregister label from network"),
    UNLOCK_LABEL("Unlock label (removes network key)"),
    UNKNOWN("Unknown task");

    public static final String IMAGE_SQL;
    private final String description;

    private TaskType(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isImage() {
        return this == IMAGE || this == PRELOAD_IMAGE;
    }

    public boolean isDisplayUpdate() {
        return this == IMAGE || this == SWITCH_PAGE || this == REFRESH_DISPLAY;
    }

    public boolean isLabelMaintenance() {
        return this == REGISTER_LABEL || this == UNREGISTER_LABEL;
    }

    public boolean isData() {
        return this.isImage() || this == FIRMWARE;
    }

    public boolean isCommand() {
        return !this.isData() && !this.isLabelMaintenance() && this != UNKNOWN;
    }

    public boolean isLicenceRequired() {
        return this != UNREGISTER_LABEL;
    }

    static {
        IMAGE_SQL = SqlUtils.getSqlCondition((Object[])new Object[]{IMAGE, PRELOAD_IMAGE});
    }
}

