/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.processing.model;

import at.mrdevelopment.esl.wireless.Address;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class LabelListModel
implements ListModel {
    private List<Address> labels = new ArrayList<Address>();
    private Set<ListDataListener> listeners = new HashSet<ListDataListener>();

    @Override
    public int getSize() {
        return this.labels.size();
    }

    public Object getElementAt(int index) {
        if (index < this.labels.size()) {
            return this.labels.get(index);
        }
        return null;
    }

    @Override
    public void addListDataListener(ListDataListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListDataListener(ListDataListener listener) {
        this.listeners.remove(listener);
    }

    public void addLabel(Address address) {
        if (address != null && !this.labels.contains(address)) {
            this.labels.add(address);
            Collections.sort(this.labels);
            this.notifyContentChanged();
        }
    }

    public void addLabels(Collection<Address> addresses) {
        for (Address address : addresses) {
            if (this.labels.contains(address)) continue;
            this.labels.add(address);
        }
        Collections.sort(this.labels);
        this.notifyContentChanged();
    }

    public void removeLabel(Collection<Address> addresses) {
        if (addresses != null) {
            for (Address address : addresses) {
                if (address == null) continue;
                this.labels.remove(address);
            }
            Collections.sort(this.labels);
            this.notifyContentChanged();
        }
    }

    private void notifyContentChanged() {
        for (ListDataListener listener : this.listeners) {
            listener.intervalAdded(new ListDataEvent(this, 0, 0, this.labels.size()));
        }
    }

    public List<Address> getLabels() {
        return this.labels;
    }

    public boolean contains(Address address) {
        return this.labels.contains(address);
    }

    public int getIndex(Address address) {
        return this.labels.indexOf(address);
    }
}

