/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.processing;

import at.mrdevelopment.esl.processing.BroadcastProcessor;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.Shutdownable;
import at.mrdevelopment.toolkit.StreamUtils;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;

public class BroadcastListener
extends Thread
implements Shutdownable {
    static ESLLogger logger = ESLLogger.getLogger(BroadcastListener.class);
    private static final int PACKET_SIZE = 5000;
    private final BroadcastProcessor processor;
    private final DatagramSocket socket;
    private volatile boolean shutdownRequested = false;

    public BroadcastListener(BroadcastProcessor processor, int port) throws InitializationException {
        this.processor = processor;
        try {
            this.socket = new DatagramSocket(port, InetAddress.getByName("0.0.0.0"));
        }
        catch (SocketException exc) {
            throw new InitializationException((Throwable)exc);
        }
        catch (UnknownHostException exc) {
            throw new InitializationException((Throwable)exc);
        }
    }

    @Override
    public void run() {
        byte[] recvBuf = new byte[5000];
        DatagramPacket recvPacket = new DatagramPacket(recvBuf, recvBuf.length);
        while (!this.shutdownRequested) {
            try {
                String message = this.receiveMessage(recvPacket);
                this.processor.processBroadcast(message, recvPacket.getAddress().getHostAddress());
            }
            catch (InterruptedException ignore) {
            }
            catch (IOException exc) {
                logger.warn("Failed to read access point broadcast packet");
                logger.logExceptionIfDebugEnabled((Throwable)exc);
            }
            catch (Exception exc) {
                logger.error("Unknown exception during processing of access point broadcast packet");
                logger.logException((Throwable)exc);
            }
        }
    }

    public void shutdown() {
        logger.info("Shutdown BroadcastListener thread");
        this.shutdownRequested = true;
        this.socket.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String receiveMessage(DatagramPacket recvPacket) throws IOException, InterruptedException, ClassNotFoundException {
        ObjectInputStream objectInputStream = this.receiveFromSocket(recvPacket);
        try {
            String string = (String)objectInputStream.readObject();
            return string;
        }
        finally {
            StreamUtils.close((InputStream)objectInputStream);
        }
    }

    private ObjectInputStream receiveFromSocket(DatagramPacket recvPacket) throws IOException, InterruptedException {
        try {
            this.socket.receive(recvPacket);
            return new ObjectInputStream(new BufferedInputStream(new ByteArrayInputStream(recvPacket.getData())));
        }
        catch (SocketException exc) {
            if (!this.shutdownRequested) {
                throw exc;
            }
            throw new InterruptedException();
        }
    }

    protected DatagramSocket getSocket() {
        return this.socket;
    }

    protected BroadcastProcessor getProcessor() {
        return this.processor;
    }
}

