/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence.query;

import at.mrdevelopment.esl.persistence.query.QueryResult;
import java.util.List;

public class ScrollableQueryResult<T> {
    private final List<T> results;

    public static <T> QueryResult<T> getResultsForPage(List<T> results, Integer page, Integer recordsPerPage, int defaultRecordsPerPage) {
        if (page != null) {
            if (recordsPerPage == null) {
                recordsPerPage = defaultRecordsPerPage;
            }
            ScrollableQueryResult<T> scrollableQueryResult = new ScrollableQueryResult<T>(results);
            return scrollableQueryResult.getResultsForPage(page, recordsPerPage);
        }
        return QueryResult.newUnpagedResult(results);
    }

    public ScrollableQueryResult(List<T> results) {
        this.results = results;
    }

    public QueryResult<T> getResultsForPage(int page, int recordsPerPage) {
        int fromIndex = Math.min(this.results.size(), page * recordsPerPage);
        int toIndex = Math.min(this.results.size(), (page + 1) * recordsPerPage);
        List<T> recordsForPage = this.results.subList(fromIndex, toIndex);
        return QueryResult.newPagedResult(recordsForPage, this.results.size(), page, recordsPerPage);
    }

    public int getTotalRecords() {
        return this.results.size();
    }
}

