/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence.query;

import java.util.List;

public class QueryResult<T> {
    private final List<T> records;
    private final boolean pagedResults;
    private final int totalRecords;
    private final int page;
    private final int recordsPerPage;

    public static <T> QueryResult<T> newPagedResult(List<T> records, int totalRecords, int page, int recordsPerPage) {
        return new QueryResult<T>(records, true, totalRecords, page, recordsPerPage);
    }

    public static <T> QueryResult<T> newUnpagedResult(List<T> records) {
        return new QueryResult<T>(records, false, records.size(), 0, records.size());
    }

    private QueryResult(List<T> records, boolean pagedResults, int totalRecords, int page, int recordsPerPage) {
        this.records = records;
        this.pagedResults = pagedResults;
        this.totalRecords = totalRecords;
        this.page = page;
        this.recordsPerPage = recordsPerPage;
    }

    public List<T> getRecords() {
        return this.records;
    }

    public boolean isPagedResults() {
        return this.pagedResults;
    }

    public int getTotalRecords() {
        return this.totalRecords;
    }

    public int getTotalPages() {
        return Math.max(1, (int)Math.ceil((double)this.totalRecords / (double)this.recordsPerPage));
    }

    public int getPage() {
        return this.page;
    }

    public int getRecordsPerPage() {
        return this.recordsPerPage;
    }
}

