/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence.query;

public class QueryRestriction<S> {
    private static QueryRestriction<Void> UNPAGED_QUERY = new QueryRestriction<Object>(null, null, null);
    private final S searchKey;
    private final Integer page;
    private final Integer recordsPerPage;

    public static QueryRestriction<Void> newQuery(Integer page, Integer recordsPerPage, int defaultRecordsPerPage) {
        if (recordsPerPage == null) {
            recordsPerPage = defaultRecordsPerPage;
        }
        return page != null ? QueryRestriction.newPagedQuery(page, recordsPerPage) : QueryRestriction.newUnpagedQuery();
    }

    public static <S> QueryRestriction<S> newSearchQuery(Class<S> type, S searchKey, Integer page, Integer recordsPerPage, int defaultRecordsPerPage) {
        if (recordsPerPage == null) {
            recordsPerPage = defaultRecordsPerPage;
        }
        return page != null ? QueryRestriction.newPagedSearchQuery(type, searchKey, page, recordsPerPage) : QueryRestriction.newUnpagedSearchQuery(type, searchKey);
    }

    public static QueryRestriction<Void> newPagedQuery(int page, int recordsPerPage) {
        return new QueryRestriction<Object>(null, page, recordsPerPage);
    }

    public static QueryRestriction<Void> newUnpagedQuery() {
        return UNPAGED_QUERY;
    }

    private static <S> QueryRestriction<S> newPagedSearchQuery(Class<S> type, S searchKey, int page, int recordsPerPage) {
        return new QueryRestriction<S>(searchKey, page, recordsPerPage);
    }

    public static <S> QueryRestriction<S> newUnpagedSearchQuery(Class<S> type, S searchKey) {
        return new QueryRestriction<S>(searchKey, null, null);
    }

    private QueryRestriction(S searchKey, Integer page, Integer recordsPerPage) {
        this.searchKey = searchKey;
        this.page = page;
        this.recordsPerPage = recordsPerPage;
    }

    public S getSearchKey() {
        return this.searchKey;
    }

    public boolean isPagedResults() {
        return this.page != null;
    }

    public Integer getPage() {
        return this.page;
    }

    public Integer getRecordsPerPage() {
        return this.recordsPerPage;
    }
}

