/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence;

import at.mrdevelopment.esl.persistence.DatasetField;
import at.mrdevelopment.esl.persistence.annotation.Displayable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.lang.StringUtils;

public class RecursiveDatasetField
extends DatasetField {
    private final String fieldName;

    public RecursiveDatasetField(String fieldName, DatasetField datasetField) {
        super(datasetField);
        this.fieldName = fieldName;
    }

    @Override
    public boolean isDisplayable() {
        return super.isDisplayable() && !this.getGetterMethod().getAnnotation(Displayable.class).ignoreOnRecursion();
    }

    @Override
    public Object getValue(Object record) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, SecurityException, NoSuchMethodException {
        Method method = this.getFieldGetterMethod(record.getClass());
        Object field = method.invoke(record, new Object[0]);
        return field != null ? super.getValue(field) : null;
    }

    @Override
    public void setValue(Object record, Object value) throws IllegalArgumentException, SecurityException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (super.isWritable()) {
            Method method = this.getFieldGetterMethod(record.getClass());
            Object field = method.invoke(record, new Object[0]);
            super.setValue(field, value);
        }
    }

    private Method getFieldGetterMethod(Class<?> recordClass) throws SecurityException, NoSuchMethodException {
        return recordClass.getMethod("get" + StringUtils.capitalize((String)this.fieldName), new Class[0]);
    }
}

