/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence;

import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.dataset.Dataset;
import at.mrdevelopment.esl.persistence.record.Commit;
import at.mrdevelopment.esl.persistence.record.CommitState;
import at.mrdevelopment.esl.persistence.record.Commitable;
import at.mrdevelopment.esl.persistence.record.Id;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;

public class RecordUtils {
    public static int getFailedCount(Collection<? extends Commitable> commits) {
        int failedCount = 0;
        for (Commitable commitable : commits) {
            if (!commitable.getCommitState().isFailed()) continue;
            ++failedCount;
        }
        return failedCount;
    }

    public static int getModifiedCount(Collection<? extends Commitable> commits) {
        int failedCount = 0;
        for (Commitable commitable : commits) {
            if (!commitable.getCommitState().isModified()) continue;
            ++failedCount;
        }
        return failedCount;
    }

    public static <T extends Commitable> Collection<Id> toIds(Collection<T> records) {
        ArrayList<Id> ids = new ArrayList<Id>(records.size());
        for (Commitable record : records) {
            ids.add(new Id(record.getId(), record.getTransmissionId(), record.getCommitState(), record.getCommitMessage()));
        }
        return ids;
    }

    public static <T extends Commitable> Collection<Commit> toCommits(Collection<T> records) {
        ArrayList<Commit> commits = new ArrayList<Commit>(records.size());
        for (Commitable record : records) {
            commits.add(new Commit(record.getId(), record.getTransmissionId(), record.getCommitState(), record.getCommitMessage()));
        }
        return commits;
    }

    public static <T extends Commitable> Collection<T> toRecords(Collection<Id> recordIds, Dataset<T> dataset) throws DatasetException {
        ArrayList<T> records = new ArrayList<T>(recordIds.size());
        for (Id id : recordIds) {
            T record = dataset.queryById(id.getId());
            if (record == null) continue;
            record.setTransmissionId(id.getTransmissionId());
            record.setCommitState(record.getCommitState());
            records.add(record);
        }
        return records;
    }

    public static <T extends Commitable> Commit toCommit(T record) {
        return new Commit(record.getId(), record.getTransmissionId(), record.getCommitState(), record.getCommitMessage());
    }

    public static <T extends Commitable> void setTransmissionIds(Collection<T> records) {
        long transmissionId = 1L;
        for (Commitable record : records) {
            record.setTransmissionId(transmissionId++);
        }
    }

    public static <T extends Commitable> void applyCommits(Collection<Commit> commits, Collection<T> records) {
        HashMap<Long, Commitable> recordMap = new HashMap<Long, Commitable>();
        for (Commitable record : records) {
            recordMap.put(record.getTransmissionId(), record);
        }
        for (Commit commit : commits) {
            Commitable record = (Commitable)recordMap.remove(commit.getTransmissionId());
            if (record == null) continue;
            record.setId(commit.getId());
            record.setCommitState(commit.getCommitState());
            record.setCommitMessage(commit.getCommitMessage());
        }
        for (Commitable record : recordMap.values()) {
            record.setCommitState(CommitState.FAILED);
            record.setCommitMessage("No commit status returned from server");
        }
    }
}

